/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import java.io.InterruptedIOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.retry.DefaultRetryContext;
import org.mule.retry.PolicyStatus;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.retry.notifiers.ConnectNotifier;

public abstract class AbstractPolicyTemplate
implements RetryPolicyTemplate {
    protected RetryNotifier notifier = new ConnectNotifier();
    private Map metaInfo;
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public RetryContext execute(RetryCallback callback, WorkManager workManager) throws Exception {
        PolicyStatus status = null;
        RetryPolicy policy = this.createRetryInstance();
        DefaultRetryContext context = new DefaultRetryContext(callback.getWorkDescription());
        if (this.metaInfo != null) {
            context.setMetaInfo(this.metaInfo);
        }
        try {
            Exception cause = null;
            while (true) {
                try {
                    callback.doWork(context);
                    if (this.notifier == null) break;
                    this.notifier.onSuccess(context);
                }
                catch (Exception e) {
                    cause = e;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)cause);
                    }
                    if (this.notifier != null) {
                        this.notifier.onFailure(context, cause);
                    }
                    if (!(cause instanceof InterruptedException) && !(cause instanceof InterruptedIOException)) continue;
                    this.logger.error((Object)"Process was interrupted (InterruptedException), ceasing process");
                    break;
                    if ((status = policy.applyPolicy(cause)).isOk()) continue;
                }
                break;
            }
            if (status == null || status.isOk()) {
                DefaultRetryContext defaultRetryContext = context;
                return defaultRetryContext;
            }
            context.setFailed(cause);
            throw new RetryPolicyExhaustedException(cause, (Object)callback.getWorkDescription());
        }
        finally {
            if (status != null && status.getThrowable() != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)status.getThrowable());
            }
        }
    }

    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    public Map getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(Map metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setId(String id) {
    }
}

