/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.registry.AbstractRegistry;
import org.mule.registry.ExpressionEvaluatorProcessor;
import org.mule.registry.MuleContextProcessor;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;

public class TransientRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog(TransientRegistry.class);
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    private Map registry = new HashMap();
    private MuleContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientRegistry(MuleContext context) {
        super(REGISTRY_ID);
        this.context = context;
        Map map = this.registry;
        synchronized (map) {
            this.registry.put("_muleContextProcessor", new MuleContextProcessor(context));
            this.registry.put("_mulePropertyExtractorProcessor", new ExpressionEvaluatorProcessor(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialise() throws InitialisationException {
        this.applyProcessors(this.lookupObjects(Connector.class));
        this.applyProcessors(this.lookupObjects(Transformer.class));
        this.applyProcessors(this.lookupObjects(ImmutableEndpoint.class));
        this.applyProcessors(this.lookupObjects(Agent.class));
        this.applyProcessors(this.lookupObjects(Model.class));
        this.applyProcessors(this.lookupObjects(Service.class));
        this.applyProcessors(this.lookupObjects(Object.class));
        Map map = this.registry;
        synchronized (map) {
            Collection allObjects = this.lookupObjects(Object.class);
            for (Object obj : allObjects) {
                if (!(obj instanceof Initialisable)) continue;
                ((Initialisable)obj).initialise();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        Map map = this.registry;
        synchronized (map) {
            Collection allObjects = this.lookupObjects(Object.class);
            for (Object obj : allObjects) {
                if (!(obj instanceof Disposable)) continue;
                ((Disposable)obj).dispose();
            }
        }
    }

    protected void applyProcessors(Map objects) {
        if (objects == null) {
            return;
        }
        for (Object o : objects.values()) {
            Collection processors = this.lookupObjects(ObjectProcessor.class);
            for (ObjectProcessor op : processors) {
                op.process(o);
            }
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry entry : objects.entrySet()) {
            this.registerObject(entry.getKey().toString(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupObject(String key) {
        Map map = this.registry;
        synchronized (map) {
            return this.registry.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection lookupObjects(Class returntype) {
        Map map = this.registry;
        synchronized (map) {
            return CollectionUtils.select(this.registry.values(), (Predicate)new InstanceofPredicate(returntype));
        }
    }

    protected Object applyProcessors(Object object) {
        Object theObject = object;
        Collection processors = this.lookupObjects(ObjectProcessor.class);
        for (ObjectProcessor o : processors) {
            theObject = o.process(theObject);
        }
        return theObject;
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(String key, Object object, Object metadata) throws RegistrationException {
        if (StringUtils.isBlank((String)key)) {
            throw new RegistrationException("Attempt to register object with no key");
        }
        this.logger.debug((Object)"registering object");
        if (MuleServer.getMuleContext().isInitialised() || MuleServer.getMuleContext().isInitialising()) {
            this.logger.debug((Object)"applying processors");
            object = this.applyProcessors(object);
        }
        Map map = this.registry;
        synchronized (map) {
            if (this.registry.containsKey(key)) {
                this.logger.warn((Object)("TransientRegistry already contains an object named '" + key + "'.  The previous object will be overwritten."));
            }
            this.registry.put(key, object);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("applying lifecycle to object: " + object));
            }
            this.context.getLifecycleManager().applyCompletedPhases(object);
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        Object obj;
        Map map = this.registry;
        synchronized (map) {
            obj = this.registry.remove(key);
        }
        if (obj instanceof Stoppable) {
            try {
                ((Stoppable)obj).stop();
            }
            catch (MuleException e) {
                throw new RegistrationException(e);
            }
        }
    }

    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, Object.class);
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }
}

