/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;

public class MessageAttachmentsListExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "attachments-list";
    public static final String DELIM = ",";
    public static final String ALL_ARGUMENT = "{all}";

    public Object evaluate(String expression, MuleMessage message) {
        ArrayList<DataHandler> result;
        if (ALL_ARGUMENT.equals(expression)) {
            result = new ArrayList<DataHandler>(message.getAttachmentNames().size());
            for (String name : message.getAttachmentNames()) {
                result.add(message.getAttachment(name));
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(expression, DELIM);
            result = new ArrayList(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                boolean required;
                String s = tokenizer.nextToken();
                if ((s = s.trim()).endsWith("*")) {
                    s = s.substring(s.length() - 1);
                    required = false;
                } else {
                    required = true;
                }
                DataHandler val = message.getAttachment(s);
                if (val != null) {
                    result.add(val);
                    continue;
                }
                if (!required) continue;
                throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

