/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.Registry;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceFinder;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.DefaultModelServiceDescriptor;
import org.mule.transport.service.DefaultTransportServiceDescriptor;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;

public class ServiceDescriptorFactory {
    @Deprecated
    public static final String PROVIDER_SERVICE_TYPE = "transport";
    public static final String TRANSPORT_SERVICE_TYPE = "transport";
    public static final String MODEL_SERVICE_TYPE = "model";
    public static final String EXCEPTION_SERVICE_TYPE = "exception";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public static ServiceDescriptor create(String type, String name, Properties props, Properties overrides, Registry registry, ClassLoader classLoader) throws ServiceException {
        if (overrides != null) {
            props.putAll((Map<?, ?>)overrides);
        }
        String serviceFinderClass = (String)props.remove("service.finder");
        AbstractServiceDescriptor sd = null;
        if (type.equals("transport")) {
            try {
                sd = new DefaultTransportServiceDescriptor(name, props, registry, classLoader);
            }
            catch (Exception e) {
                throw (IllegalStateException)new IllegalStateException("Cannot create transport " + name).initCause(e);
            }
            Properties exceptionMappingProps = SpiUtils.findServiceDescriptor(EXCEPTION_SERVICE_TYPE, name + "-exception-mappings");
            ((TransportServiceDescriptor)((Object)sd)).setExceptionMappings(exceptionMappingProps);
        } else if (type.equals(MODEL_SERVICE_TYPE)) {
            sd = new DefaultModelServiceDescriptor(name, props);
        } else {
            throw new ServiceException(CoreMessages.unrecognisedServiceType(type));
        }
        if (StringUtils.isNotBlank((String)serviceFinderClass)) {
            ServiceFinder finder;
            try {
                finder = (ServiceFinder)ClassUtils.instanciateClass(serviceFinderClass, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.cannotInstanciateFinder(serviceFinderClass), (Throwable)e);
            }
            String realService = finder.findService(name, sd, props);
            if (realService != null) {
                return MuleServer.getMuleContext().getRegistry().lookupServiceDescriptor("transport", realService, overrides);
            }
            throw new ServiceException(CoreMessages.serviceFinderCantFindService(name));
        }
        return sd;
    }
}

