/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageAdapter;
import org.mule.util.StringUtils;
import org.mule.util.expression.ExpressionEvaluator;
import org.mule.util.expression.MessagePayloadExpressionEvaluator;

public class MessageExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "message";
    protected final transient Log logger = LogFactory.getLog(MessagePayloadExpressionEvaluator.class);

    public Object evaluate(String expression, Object message) {
        if (message instanceof MuleMessage) {
            if (StringUtils.isEmpty((String)expression)) {
                return message;
            }
            if (expression.equals("id")) {
                return ((MuleMessage)message).getUniqueId();
            }
            if (expression.equals("correlationId")) {
                return ((MuleMessage)message).getCorrelationId();
            }
            if (expression.equals("correlationSequence")) {
                return new Integer(((MuleMessage)message).getCorrelationSequence());
            }
            if (expression.equals("correlationGroupSize")) {
                return new Integer(((MuleMessage)message).getCorrelationGroupSize());
            }
            if (expression.equals("replyTo")) {
                return ((MuleMessage)message).getReplyTo();
            }
            if (expression.equals("payload")) {
                return ((MuleMessage)message).getPayload();
            }
            if (expression.equals("encoding")) {
                return ((MuleMessage)message).getEncoding();
            }
            if (expression.equals("exception")) {
                ExceptionPayload ep = ((MuleMessage)message).getExceptionPayload();
                if (ep != null) {
                    return ep.getException();
                }
                return null;
            }
            throw new IllegalArgumentException(expression);
        }
        this.logger.warn((Object)"Message is not of type MuleMessage, the expression will return the object without modification");
        if (message instanceof MessageAdapter) {
            return ((MessageAdapter)message).getPayload();
        }
        return message;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

