/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.TemplateParser;
import org.mule.util.expression.ExpressionEvaluator;
import org.mule.util.expression.ExpressionRuntimeException;

public class ExpressionEvaluatorManager {
    protected static final transient Log logger = LogFactory.getLog(ExpressionEvaluatorManager.class);
    public static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    public static final String DEFAULT_EXPRESSION_POSTFIX = "]";
    private static TemplateParser parser = TemplateParser.createMuleStyleParser();
    private static ConcurrentMap evaluators = new ConcurrentHashMap(8);

    public static void registerEvaluator(ExpressionEvaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
        }
        String name = evaluator.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluators already contain an object named '" + name + "'.  The previous object will be overwritten."));
        }
        evaluators.put((Object)evaluator.getName(), (Object)evaluator);
    }

    public static boolean isEvaluatorRegistered(String name) {
        return evaluators.containsKey((Object)name);
    }

    public static ExpressionEvaluator unregisterEvaluator(String name) {
        if (name == null) {
            return null;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)evaluators.remove((Object)name);
        if (evaluator instanceof Disposable) {
            ((Disposable)((Object)evaluator)).dispose();
        }
        return evaluator;
    }

    public static Object evaluate(String expression, Object object) throws ExpressionRuntimeException {
        return ExpressionEvaluatorManager.evaluate(expression, object, DEFAULT_EXPRESSION_PREFIX, false);
    }

    public static Object evaluate(String expression, Object object, boolean failIfNull) throws ExpressionRuntimeException {
        return ExpressionEvaluatorManager.evaluate(expression, object, DEFAULT_EXPRESSION_PREFIX, failIfNull);
    }

    public static Object evaluate(String expression, String evaluator, Object object, boolean failIfNull) throws ExpressionRuntimeException {
        ExpressionEvaluator extractor = (ExpressionEvaluator)evaluators.get((Object)evaluator);
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(evaluator).getMessage());
        }
        Object result = extractor.evaluate(expression, object);
        if (result == null && failIfNull) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(evaluator, expression));
        }
        return result;
    }

    public static Object evaluate(String expression, Object object, String expressionPrefix, boolean failIfNull) throws ExpressionRuntimeException {
        String name;
        int i;
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith(expressionPrefix)) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            name = expression.substring(0, i);
            expression = expression.substring(i + 1);
        } else {
            name = expression;
            expression = null;
        }
        return ExpressionEvaluatorManager.evaluate(expression, name, object, failIfNull);
    }

    public static String parse(String expression, Object object) throws ExpressionRuntimeException {
        return ExpressionEvaluatorManager.parse(expression, object, false);
    }

    public static String parse(String expression, final Object object, final boolean failIfNull) throws ExpressionRuntimeException {
        return parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                return ExpressionEvaluatorManager.evaluate(token, object, failIfNull);
            }
        }, expression);
    }

    public static synchronized void clearEvaluators() {
        for (ExpressionEvaluator evaluator : evaluators.values()) {
            if (!(evaluator instanceof Disposable)) continue;
            ((Disposable)((Object)evaluator)).dispose();
        }
        evaluators.clear();
    }

    public static boolean isValidExpression(String expression) {
        final AtomicBoolean valid = new AtomicBoolean(true);
        final AtomicBoolean match = new AtomicBoolean(false);
        final StringBuffer message = new StringBuffer();
        parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                match.set(true);
                if (token.indexOf(":") == -1) {
                    if (valid.get()) {
                        valid.compareAndSet(true, false);
                    }
                    message.append(token).append(" is malformed\n");
                }
                return null;
            }
        }, expression);
        if (message.length() > 0) {
            logger.warn((Object)("Expression " + expression + " is malformed: " + message.toString()));
        }
        return match.get() && valid.get();
    }
}

