/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.ReceiveException;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.transport.AbstractConnectable;

public abstract class AbstractMessageRequester
extends AbstractConnectable
implements MessageRequester {
    public AbstractMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    public final void initialise() throws InitialisationException {
        super.initialise();
        this.doInitialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        super.dispose();
        try {
            this.disposing.set(true);
            this.doDispose();
        }
        finally {
            this.disposed.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MuleMessage request(long timeout) throws Exception {
        try {
            this.connect();
            MuleMessage result = null;
            try {
                result = this.doRequest(timeout);
            }
            finally {
                if (this.useStrictConnectDisconnect) {
                    this.disconnect();
                }
            }
            if (result != null && this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new EndpointMessageNotification(result, this.endpoint, null, 804));
            }
            return result;
        }
        catch (ReceiveException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getRequesterWorkManager();
        }
        catch (MuleException e) {
            this.handleException(e);
            return null;
        }
    }

    protected abstract MuleMessage doRequest(long var1) throws Exception;
}

