/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.EventCorrelator;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    private int timeout = -1;
    private boolean failOnTimeout = true;
    private EventCorrelator eventCorrelator;

    public void initialise() throws InitialisationException {
        if (this.timeout == -1) {
            this.setTimeout(this.muleContext.getConfiguration().getDefaultSynchronousEventTimeout());
        }
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(), this.messageInfoMapping, this.muleContext);
        this.eventCorrelator.setTimeout(this.getTimeout());
        this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
        super.initialise();
    }

    protected EventCorrelator getEventCorrelator() {
        return this.eventCorrelator;
    }

    public void process(MuleEvent event) throws RoutingException {
        this.eventCorrelator.addEvent(event);
    }

    public MuleMessage getResponse(MuleMessage message) throws RoutingException {
        return this.eventCorrelator.getResponse(message);
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback();

    protected MuleMessage aggregateEvents(EventGroup events) throws RoutingException {
        return null;
    }
}

