/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.AbstractRecipientList;
import org.mule.util.StringUtils;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class ExpressionRecipientList
extends AbstractRecipientList {
    public static final String DEFAULT_SELECTOR_PROPERTY = "recipients";
    public static final String DEFAULT_SELECTOR_EVALUATOR = "header";
    public static final String DEFAULT_SELECTOR_EXPRESSION = "recipients";
    private String expression = "recipients";
    private String evaluator = "header";
    private String customEvaluator;
    private String fullExpression;

    protected List getRecipients(MuleMessage message) throws CouldNotRouteOutboundMessageException {
        String expr = this.getFullExpression();
        if (!ExpressionEvaluatorManager.isValidExpression(expr)) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionInvalidForProperty("expression", expr), message, null);
        }
        Object msgRecipients = ExpressionEvaluatorManager.evaluate(expr, message);
        if (msgRecipients == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSetOnEvent(this.getFullExpression()), message, null);
        }
        if (msgRecipients instanceof String) {
            return Arrays.asList(StringUtils.splitAndTrim(msgRecipients.toString(), " ,;:"));
        }
        if (msgRecipients instanceof List) {
            return new ArrayList((List)msgRecipients);
        }
        this.logger.error((Object)("Recipients on message are neither String nor List but: " + msgRecipients.getClass()));
        throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.getFullExpression(), new Class[]{String.class, List.class}, msgRecipients.getClass()), message, null);
    }

    public String getFullExpression() {
        if (this.fullExpression == null) {
            if (this.evaluator.equalsIgnoreCase("custom")) {
                this.evaluator = this.customEvaluator;
            }
            this.fullExpression = MessageFormat.format("{0}{1}:{2}{3}", "#[", this.evaluator, this.expression, "]");
            this.logger.debug((Object)("Full expression for EndpointSelector is: " + this.fullExpression));
        }
        return this.fullExpression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = customEvaluator;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }
}

