/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.mule.api.MuleException;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.util.pool.DefaultLifecycleEnabledObjectPool;
import org.mule.util.pool.LifecyleEnabledObjectPool;

public class PooledJavaComponent
extends AbstractJavaComponent {
    protected PoolingProfile poolingProfile;
    protected LifecyleEnabledObjectPool lifecycleAdapterPool;

    public PooledJavaComponent() {
    }

    public PooledJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null);
    }

    public PooledJavaComponent(ObjectFactory objectFactory, PoolingProfile poolingProfile) {
        super(objectFactory);
        this.poolingProfile = poolingProfile;
    }

    public PooledJavaComponent(ObjectFactory objectFactory, PoolingProfile poolingProfile, EntryPointResolverSet entryPointResolverSet, NestedRouterCollection nestedRouterCollection) {
        super(objectFactory, entryPointResolverSet, nestedRouterCollection);
        this.poolingProfile = poolingProfile;
    }

    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        return (LifecycleAdapter)this.lifecycleAdapterPool.borrowObject();
    }

    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) {
        this.lifecycleAdapterPool.returnObject(lifecycleAdapter);
    }

    protected void doStart() throws MuleException {
        super.doStart();
        this.lifecycleAdapterPool = new DefaultLifecycleEnabledObjectPool(new LifeCycleAdaptorFactory(), this.poolingProfile);
        this.lifecycleAdapterPool.initialise();
        this.lifecycleAdapterPool.start();
    }

    protected void doStop() throws MuleException {
        super.doStop();
        if (this.lifecycleAdapterPool != null) {
            this.lifecycleAdapterPool.stop();
            this.lifecycleAdapterPool.close();
            this.lifecycleAdapterPool = null;
        }
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    protected class LifeCycleAdaptorFactory
    implements ObjectFactory {
        protected LifeCycleAdaptorFactory() {
        }

        public Object getInstance() throws Exception {
            return PooledJavaComponent.this.createLifeCycleAdaptor();
        }

        public Class getObjectClass() {
            return LifecycleAdapter.class;
        }

        public void initialise() throws InitialisationException {
            PooledJavaComponent.this.objectFactory.initialise();
        }

        public void dispose() {
            PooledJavaComponent.this.objectFactory.dispose();
        }

        public void addObjectInitialisationCallback(InitialisationCallback callback) {
            PooledJavaComponent.this.objectFactory.addObjectInitialisationCallback(callback);
        }

        public boolean isSingleton() {
            return false;
        }

        public boolean isExternallyManagedLifecycle() {
            return PooledJavaComponent.this.objectFactory.isExternallyManagedLifecycle();
        }
    }
}

