/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEventContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.routing.NestedRouter;
import org.mule.api.service.ServiceAware;
import org.mule.api.service.ServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.util.ClassUtils;

public class DefaultLifecycleAdapter
implements LifecycleAdapter {
    protected static final Log logger = LogFactory.getLog(DefaultLifecycleAdapter.class);
    protected Object componentObject;
    protected JavaComponent component;
    protected EntryPointResolverSet entryPointResolver;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;

    public DefaultLifecycleAdapter(Object componentObject, JavaComponent component) throws MuleException {
        if (componentObject == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (this.entryPointResolver == null) {
            this.entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.componentObject = componentObject;
        this.component = component;
    }

    public DefaultLifecycleAdapter(Object componentObject, JavaComponent component, EntryPointResolverSet entryPointResolver) throws MuleException {
        this(componentObject, component);
        this.entryPointResolver = entryPointResolver;
        this.isStartable = Startable.class.isInstance(componentObject);
        this.isStoppable = Stoppable.class.isInstance(componentObject);
        this.isDisposable = Disposable.class.isInstance(componentObject);
        if (componentObject instanceof ServiceAware) {
            ((ServiceAware)componentObject).setService(component.getService());
        }
        this.configureNestedRouter();
    }

    public void start() throws MuleException {
        if (this.isStartable) {
            try {
                ((Startable)this.componentObject).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("UMO Service: " + this.component.getService().getName()), (Throwable)e);
            }
        } else {
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.componentObject).stop();
                this.started = false;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("UMO Service: " + this.component.getService().getName()), (Throwable)e);
            }
        } else {
            this.started = false;
        }
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                ((Disposable)this.componentObject).dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.component.getService().getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Object invoke(MuleEvent event) throws MuleException {
        Object result;
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(event);
        try {
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.componentObject, eventContext) : this.entryPointResolver.invoke(this.componentObject, eventContext);
        }
        catch (Exception e) {
            throw new ServiceException(RequestContext.getEventContext().getMessage(), this.component.getService(), (Throwable)e);
        }
        return result;
    }

    public void initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.componentObject)) {
            ((Initialisable)this.componentObject).initialise();
        }
    }

    protected void configureNestedRouter() throws MuleException {
        if (this.component.getNestedRouter() != null) {
            HashMap bindings = new HashMap();
            for (NestedRouter nestedRouter : this.component.getNestedRouter().getRouters()) {
                Object proxy = bindings.get(nestedRouter.getInterface());
                if (proxy == null) {
                    proxy = nestedRouter.createProxy(this.componentObject);
                    bindings.put(nestedRouter.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()});
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.componentObject, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(nestedRouter, this.componentObject.getClass()), (Throwable)e, this);
                    }
                }
                NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(nestedRouter);
            }
        }
    }
}

