/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleSessionHandler;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InvalidEndpointTypeException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.util.StreamCloserService;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ExceptionNotification;
import org.mule.message.ExceptionMessage;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.NullPayload;
import org.mule.util.CollectionUtils;

public abstract class AbstractExceptionListener
implements ExceptionListener,
Initialisable,
Disposable,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected MuleContext muleContext;
    protected WildcardFilter rollbackTxFilter;
    protected WildcardFilter commitTxFilter;
    protected boolean enableNotifications = true;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        if (endpoints != null) {
            this.endpoints.clear();
            for (ImmutableEndpoint endpoint : endpoints) {
                if (endpoint instanceof OutboundEndpoint) continue;
                throw new InvalidEndpointTypeException(CoreMessages.exceptionListenerMustUseOutboundEndpoint(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("List of endpoints = null");
        }
        this.endpoints.addAll(endpoints);
    }

    public void addEndpoint(OutboundEndpoint endpoint) {
        if (endpoint != null) {
            this.endpoints.add(endpoint);
        }
    }

    public boolean removeEndpoint(OutboundEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public void exceptionThrown(Exception e) {
        if (this.enableNotifications) {
            this.fireNotification(new ExceptionNotification(e));
        }
        this.logException(e);
        this.handleTransaction(e);
        Throwable t = this.getExceptionType(e, RoutingException.class);
        if (t != null) {
            RoutingException re = (RoutingException)t;
            this.handleRoutingException(re.getUmoMessage(), re.getEndpoint(), e);
            return;
        }
        t = this.getExceptionType(e, MessagingException.class);
        if (t != null) {
            MessagingException me = (MessagingException)t;
            this.handleMessagingException(me.getUmoMessage(), e);
            return;
        }
        t = this.getExceptionType(e, LifecycleException.class);
        if (t != null) {
            LifecycleException le = (LifecycleException)t;
            this.handleLifecycleException(le.getComponent(), e);
            if (RequestContext.getEventContext() != null) {
                this.handleMessagingException(RequestContext.getEventContext().getMessage(), e);
            } else {
                this.logger.info((Object)"There is no current event available, routing Null message with the exception");
                this.handleMessagingException(new DefaultMuleMessage(NullPayload.getInstance()), e);
            }
            return;
        }
        this.handleStandardException(e);
    }

    protected Throwable getExceptionType(Throwable t, Class exceptionType) {
        while (t != null) {
            if (exceptionType.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.doInitialise(this.muleContext);
            this.initialised.set(true);
        }
    }

    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        this.logger.info((Object)("Initialising exception listener: " + this.toString()));
    }

    protected void handleTransaction(Throwable t) {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx == null) {
            return;
        }
        t = ExceptionHelper.getRootException(t);
        if (this.rollbackTxFilter == null && this.commitTxFilter == null) {
            this.rollbackTransaction();
        } else if (this.rollbackTxFilter != null && this.rollbackTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
        } else if (this.commitTxFilter != null && !this.commitTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
        }
    }

    protected void rollbackTransaction() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (TransactionException e) {
            this.logException(e);
        }
    }

    protected void routeException(MuleMessage message, ImmutableEndpoint failedEndpoint, Throwable t) {
        List endpoints = this.getEndpoints(t);
        if (CollectionUtils.isNotEmpty((Collection)endpoints)) {
            try {
                this.logger.error((Object)("Message being processed is: " + (message == null ? "null" : message.toString())));
                MuleEventContext ctx = RequestContext.getEventContext();
                String component = "Unknown";
                EndpointURI endpointUri = null;
                if (ctx != null) {
                    if (ctx.getService() != null) {
                        component = ctx.getService().getName();
                    }
                    endpointUri = ctx.getEndpointURI();
                } else if (failedEndpoint != null) {
                    endpointUri = failedEndpoint.getEndpointURI();
                }
                ExceptionMessage msg = new ExceptionMessage(this.getErrorMessagePayload(message), t, component, endpointUri);
                DefaultMuleMessage exceptionMessage = ctx == null ? new DefaultMuleMessage(msg) : new DefaultMuleMessage((Object)msg, ctx.getMessage());
                for (int i = 0; i < endpoints.size(); ++i) {
                    OutboundEndpoint endpoint = (OutboundEndpoint)endpoints.get(i);
                    MuleEvent exceptionEvent = new DefaultMuleEvent((MuleMessage)exceptionMessage, (ImmutableEndpoint)endpoint, new DefaultMuleSession(exceptionMessage, new MuleSessionHandler(), this.muleContext), true);
                    exceptionEvent = RequestContext.setEvent(exceptionEvent);
                    endpoint.send(exceptionEvent);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("routed Exception message via " + endpoint));
                }
            }
            catch (MuleException e) {
                this.logFatal(message, e);
                this.closeStream(message);
            }
        } else {
            this.handleTransaction(t);
            this.closeStream(message);
        }
    }

    protected void closeStream(MuleMessage message) {
        if (this.muleContext != null && message != null && this.muleContext.getRegistry().lookupObject("_muleStreamCloserService") != null) {
            ((StreamCloserService)this.muleContext.getRegistry().lookupObject("_muleStreamCloserService")).closeStream(message.getPayload());
        }
    }

    protected Object getErrorMessagePayload(MuleMessage message) {
        try {
            return message.getPayloadAsString();
        }
        catch (Exception e) {
            this.logException(e);
            this.logger.info((Object)"Failed to read message payload as string, using raw payload");
            return message.getPayload();
        }
    }

    protected List getEndpoints(Throwable t) {
        if (!this.endpoints.isEmpty()) {
            return this.endpoints;
        }
        return null;
    }

    protected void logException(Throwable t) {
        MuleException umoe = ExceptionHelper.getRootMuleException(t);
        if (umoe != null) {
            this.logger.error((Object)umoe.getDetailedMessage());
        } else {
            this.logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        }
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        this.logger.fatal((Object)("Failed to dispatch message to error queue after it failed to process.  This may cause message loss." + (message == null ? "" : "Logging Message here: \n" + message.toString())), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public void dispose() {
    }

    protected void fireNotification(ExceptionNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug((Object)("MuleContext is not yet available for firing notifications, ignoring event: " + notification));
        }
    }

    public WildcardFilter getCommitTxFilter() {
        return this.commitTxFilter;
    }

    public void setCommitTxFilter(WildcardFilter commitTxFilter) {
        this.commitTxFilter = commitTxFilter;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public WildcardFilter getRollbackTxFilter() {
        return this.rollbackTxFilter;
    }

    public void setRollbackTxFilter(WildcardFilter rollbackTxFilter) {
        this.rollbackTxFilter = rollbackTxFilter;
    }

    public abstract void handleMessagingException(MuleMessage var1, Throwable var2);

    public abstract void handleRoutingException(MuleMessage var1, ImmutableEndpoint var2, Throwable var3);

    public abstract void handleLifecycleException(Object var1, Throwable var2);

    public abstract void handleStandardException(Throwable var1);
}

