/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.store.AbstractMonitoredObjectStore;

public class InMemoryObjectStore
extends AbstractMonitoredObjectStore {
    protected ConcurrentSkipListMap store = new ConcurrentSkipListMap();

    public boolean containsObject(String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        return this.store.values().contains(new StoredObject(id, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeObject(String id, Object item) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        StoredObject obj = new StoredObject(id, item);
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(obj)) {
                return false;
            }
            boolean written = false;
            while (!written) {
                written = this.store.putIfAbsent((Object)new Long(Utils.nanoTime()), (Object)obj) == null;
            }
            return true;
        }
    }

    public Object retrieveObject(String id) throws Exception {
        StoredObject obj = (StoredObject)this.store.get((Object)id);
        if (obj != null) {
            return obj.getItem();
        }
        return null;
    }

    public boolean removeObject(String id) throws Exception {
        StoredObject obj = (StoredObject)this.store.get((Object)id);
        if (obj != null) {
            return this.store.remove((Object)obj) != null;
        }
        return true;
    }

    public final void expire() {
        int currentSize = this.store.size();
        int excess = currentSize - this.maxEntries;
        if (excess > 0) {
            while (currentSize > this.maxEntries) {
                this.store.pollFirstEntry();
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
        }
        if (this.entryTTL > 0 && currentSize != 0) {
            Long oldestKey;
            long oldestKeyValue;
            Map.Entry oldestEntry;
            long now = Utils.nanoTime();
            int expiredEntries = 0;
            while ((oldestEntry = this.store.firstEntry()) != null && TimeUnit.NANOSECONDS.toMillis(now - (oldestKeyValue = (oldestKey = (Long)oldestEntry.getKey()).longValue())) >= (long)this.entryTTL) {
                this.store.remove((Object)oldestKey);
                ++expiredEntries;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
            }
        }
    }

    protected static class StoredObject {
        private String id;
        private Object item;

        public StoredObject(String id, Object item) {
            this.id = id;
            this.item = item;
        }

        public String getId() {
            return this.id;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredObject that = (StoredObject)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("StoredObject");
            sb.append("{id='").append(this.id).append('\'');
            sb.append(", item=").append(this.item);
            sb.append('}');
            return sb.toString();
        }
    }
}

