/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Date;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.DateUtils;
import org.mule.util.UUID;
import org.mule.util.expression.ExpressionEvaluator;

public class FunctionExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "function";
    public static final String DEFAULT_DATE_FORMAT = "dd-MM-yy_HH-mm-ss.SSS";
    private final AtomicLong count = new AtomicLong(0L);
    public static final String NOW_FUNCTION = "now";
    public static final String DATE_FUNCTION = "date";
    public static final String DATESTAMP_FUNCTION = "datestamp";
    public static final String SYSTIME_FUNCTION = "systime";
    public static final String UUID_FUNCTION = "uuid";
    public static final String HOSTNAME_FUNCTION = "hostname";
    public static final String IP_FUNCTION = "ip";
    public static final String COUNT_FUNCTION = "count";

    public Object evaluate(String name, Object message) {
        if (name.equalsIgnoreCase(NOW_FUNCTION)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (name.equalsIgnoreCase(DATE_FUNCTION)) {
            return new Date(System.currentTimeMillis());
        }
        if (name.toLowerCase().startsWith(DATESTAMP_FUNCTION)) {
            String temp = name.substring(DATESTAMP_FUNCTION.length());
            if (temp.length() == 0) {
                return DateUtils.getTimeStamp(DEFAULT_DATE_FORMAT);
            }
            temp = temp.substring(1);
            return DateUtils.getTimeStamp(temp);
        }
        if (name.equalsIgnoreCase(UUID_FUNCTION)) {
            return UUID.getUUID();
        }
        if (name.equalsIgnoreCase(SYSTIME_FUNCTION)) {
            return new Long(System.currentTimeMillis());
        }
        if (name.equalsIgnoreCase(HOSTNAME_FUNCTION)) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(name), (Throwable)e);
            }
        }
        if (name.equalsIgnoreCase(IP_FUNCTION)) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(name), (Throwable)e);
            }
        }
        if (name.equalsIgnoreCase(COUNT_FUNCTION)) {
            return new Long(this.count.getAndIncrement());
        }
        throw new IllegalArgumentException(name);
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

