/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AbstractCounter;
import org.mule.util.counters.impl.AggregateCounter;

public class InstantRate
extends AggregateCounter {
    private double firstTime;
    private double lastTime;
    private double value;

    public InstantRate(String name, AbstractCounter base) {
        super(name, CounterFactory.Type.INSTANT_RATE, base);
    }

    public double nextValue() {
        if (this.firstTime == 0.0 || this.firstTime == this.lastTime) {
            return Double.NaN;
        }
        return this.value / (this.lastTime - this.firstTime) * 1000.0;
    }

    public void doCompute() {
        this.firstTime = this.lastTime;
        this.lastTime = System.currentTimeMillis();
        this.value = this.getBase().nextValue();
    }
}

