/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.MuleServer;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ArrayUtils;
import org.mule.util.CharSetUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public final class StringMessageUtils {
    public static final int MAX_ELEMENTS = 50;
    public static final int DEFAULT_MESSAGE_WIDTH = 80;

    private StringMessageUtils() {
    }

    public static String getFormattedMessage(String msg, Object[] arguments) {
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = StringMessageUtils.toString(arguments[i]);
            }
        }
        return MessageFormat.format(msg, arguments);
    }

    public static String getBoilerPlate(String message) {
        return StringMessageUtils.getBoilerPlate(message, '*', 80);
    }

    public static String getBoilerPlate(String message, char c, int maxlength) {
        return StringMessageUtils.getBoilerPlate(new ArrayList<String>(Arrays.asList(message)), c, maxlength);
    }

    public static String getBoilerPlate(List messages, char c, int maxlength) {
        int i;
        StringBuffer buf = new StringBuffer(messages.size() * maxlength);
        int trimLength = maxlength - (c == ' ' ? 2 : 4);
        for (i = 0; i < messages.size(); ++i) {
            int size = messages.get(i).toString().length();
            if (size <= trimLength) continue;
            String temp = messages.get(i).toString();
            int k = i;
            messages.remove(i);
            while (temp.length() > 0) {
                int len = trimLength <= temp.length() ? trimLength : temp.length();
                String msg = temp.substring(0, len);
                int x = msg.indexOf(SystemUtils.LINE_SEPARATOR);
                if (x > -1) {
                    msg = msg.substring(0, x);
                    len = x + 1;
                } else {
                    x = msg.lastIndexOf(32);
                    if (x > -1 && len == trimLength) {
                        msg = msg.substring(0, x);
                        len = x + 1;
                    }
                }
                if (msg.startsWith(" ")) {
                    msg = msg.substring(1);
                }
                temp = temp.substring(len);
                messages.add(k, msg);
                ++k;
            }
        }
        buf.append(SystemUtils.LINE_SEPARATOR);
        if (c != ' ') {
            buf.append(StringUtils.repeat(c, maxlength));
        }
        for (i = 0; i < messages.size(); ++i) {
            int padding;
            buf.append(SystemUtils.LINE_SEPARATOR);
            if (c != ' ') {
                buf.append(c);
            }
            buf.append(" ");
            buf.append(messages.get(i));
            String osEncoding = CharSetUtils.defaultCharsetName();
            try {
                padding = trimLength - messages.get(i).toString().getBytes(osEncoding).length;
            }
            catch (UnsupportedEncodingException ueex) {
                throw new MuleRuntimeException(CoreMessages.failedToConvertStringUsingEncoding(osEncoding), (Throwable)ueex);
            }
            if (padding > 0) {
                buf.append(StringUtils.repeat(' ', padding));
            }
            buf.append(' ');
            if (c == ' ') continue;
            buf.append(c);
        }
        buf.append(SystemUtils.LINE_SEPARATOR);
        if (c != ' ') {
            buf.append(StringUtils.repeat(c, maxlength));
        }
        return buf.toString();
    }

    public static String truncate(String message, int length, boolean includeCount) {
        if (message == null) {
            return null;
        }
        if (message.length() <= length) {
            return message;
        }
        String result = message.substring(0, length) + "...";
        if (includeCount) {
            result = result + "[" + length + " of " + message.length() + "]";
        }
        return result;
    }

    public static byte[] getBytes(String string) {
        try {
            return string.getBytes(MuleServer.getMuleContext().getConfiguration().getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Map) {
            return MapUtils.toString((Map)o, false);
        }
        if (o.getClass().isArray()) {
            return ArrayUtils.toString(o, 50);
        }
        if (o instanceof Collection) {
            return CollectionUtils.toString((Collection)o, 50);
        }
        return o.toString();
    }
}

