/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.ReceiveException;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.transport.AbstractConnectable;

public abstract class AbstractMessageRequester
extends AbstractConnectable
implements MessageRequester {
    public AbstractMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    public final MuleMessage request(long timeout) throws Exception {
        final long finalTimeout = timeout;
        try {
            RetryContext context = this.retryTemplate.execute(new RetryCallback(){

                public void doWork(RetryContext context) throws Exception {
                    AbstractMessageRequester.this.connect();
                    MuleMessage result = AbstractMessageRequester.this.doRequest(finalTimeout);
                    if (result != null && AbstractMessageRequester.this.connector.isEnableMessageEvents()) {
                        AbstractMessageRequester.this.connector.fireNotification(new EndpointMessageNotification(result, AbstractMessageRequester.this.endpoint, null, 804));
                    }
                    context.addReturnMessage(result);
                }

                public String getWorkDescription() {
                    return AbstractMessageRequester.this.getConnectionDescription();
                }
            });
            return context.getFirstReturnMessage();
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected abstract MuleMessage doRequest(long var1) throws Exception;
}

