/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import java.util.Collection;
import java.util.List;
import org.mule.DefaultExceptionStrategy;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.management.stats.ServiceStatistics;
import org.mule.service.AbstractService;
import org.mule.util.CollectionUtils;

public class DefaultServiceExceptionStrategy
extends DefaultExceptionStrategy {
    protected void defaultHandler(Throwable t) {
        ServiceStatistics statistics = this.getServiceStatistics();
        if (statistics != null) {
            statistics.incExecutionError();
        }
        super.defaultHandler(t);
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        super.logFatal(message, t);
        ServiceStatistics statistics = this.getServiceStatistics();
        if (statistics != null) {
            statistics.incFatalError();
        }
    }

    protected void routeException(MuleMessage message, ImmutableEndpoint failedEndpoint, Throwable t) {
        super.routeException(message, failedEndpoint, t);
        List endpoints = this.getEndpoints(t);
        if (CollectionUtils.isNotEmpty((Collection)endpoints) && this.getServiceStatistics() != null) {
            ServiceStatistics statistics = this.getServiceStatistics();
            for (int i = 0; i < endpoints.size(); ++i) {
                statistics.getOutboundRouterStat().incrementRoutedMessage((ImmutableEndpoint)endpoints.get(i));
            }
        }
    }

    protected ServiceStatistics getServiceStatistics() {
        MuleEvent event = RequestContext.getEvent();
        if (event == null) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current event on the context");
            return null;
        }
        if (event.getService() == null) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current service on the context. Please report this to dev@mule.codehaus.org");
            return null;
        }
        return ((AbstractService)event.getService()).getStatistics();
    }
}

