/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.routing.Router;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.RouterCollection;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractCatchAllStrategy;

public abstract class AbstractRouterCollection
implements RouterCollection,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected boolean matchAll = false;
    protected List routers = new CopyOnWriteArrayList();
    private RouterStatistics statistics;
    private RouterCatchAllStrategy catchAllStrategy;
    protected MuleContext muleContext;

    public AbstractRouterCollection(int type) {
        this.statistics = new RouterStatistics(type);
    }

    public void initialise() throws InitialisationException {
        LifecycleTransitionResult.initialiseAll(this.routers.iterator());
    }

    public void dispose() {
        for (Router router : this.routers) {
            router.dispose();
        }
    }

    public void setRouters(List routers) {
        Iterator iterator = routers.iterator();
        while (iterator.hasNext()) {
            this.addRouter((Router)iterator.next());
        }
    }

    public void addRouter(Router router) {
        router.setRouterStatistics(this.getStatistics());
        this.routers.add(router);
    }

    public Router removeRouter(Router router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public List getRouters() {
        return this.routers;
    }

    public RouterCatchAllStrategy getCatchAllStrategy() {
        return this.catchAllStrategy;
    }

    public void setCatchAllStrategy(RouterCatchAllStrategy catchAllStrategy) {
        this.catchAllStrategy = catchAllStrategy;
        if (this.catchAllStrategy != null && catchAllStrategy instanceof AbstractCatchAllStrategy) {
            ((AbstractCatchAllStrategy)this.catchAllStrategy).setStatistics(this.statistics);
        }
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public RouterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RouterStatistics stat) {
        this.statistics = stat;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

