/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.i18n.CoreMessages;
import org.mule.retry.DefaultRetryContext;
import org.mule.retry.PolicyStatus;
import org.mule.retry.notifiers.ConnectNotifier;
import org.mule.transport.FatalConnectException;

public abstract class AbstractPolicyTemplate
implements RetryPolicyTemplate {
    protected boolean connectAsychronously = false;
    protected RetryNotifier notifier = new ConnectNotifier();
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public RetryContext execute(RetryCallback callback) throws FatalConnectException {
        PolicyStatus status = null;
        RetryPolicy policy = this.createRetryInstance();
        DefaultRetryContext context = new DefaultRetryContext(callback.getWorkDescription());
        try {
            while (true) {
                try {
                    callback.doWork(context);
                    if (this.notifier == null) break;
                    this.notifier.sucess(context);
                }
                catch (Exception e) {
                    Exception cause = e;
                    if (this.notifier != null) {
                        this.notifier.failed(context, e);
                    }
                    if (!(e instanceof InterruptedException) && !(e instanceof InterruptedIOException)) continue;
                    this.logger.error((Object)"Process was interrupted (InterruptedException), ceasing process");
                    break;
                    if ((status = policy.applyPolicy(cause)).isOk()) continue;
                }
                break;
            }
            if (status == null || status.isOk()) {
                DefaultRetryContext defaultRetryContext = context;
                return defaultRetryContext;
            }
            throw new FatalConnectException(CoreMessages.failedToConnect(context.getDescription(), this), status.getThrowable(), this);
        }
        finally {
            if (status != null && status.getThrowable() != null && this.logger.isDebugEnabled()) {
                this.logger.error((Object)status.getThrowable());
            }
        }
    }

    public boolean isRetryEnabled() {
        return true;
    }

    public boolean isConnectAsynchronously() {
        return this.connectAsychronously;
    }

    public void setConectAsychronously(boolean connectAsychronously) {
        this.connectAsychronously = connectAsychronously;
    }

    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    public void setId(String id) {
    }
}

