/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.mule.MuleServer;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.RegistryBroker;
import org.mule.registry.TransientRegistry;

public abstract class AbstractRegistryBroker
implements RegistryBroker {
    public void initialise() throws InitialisationException {
        this.addRegistry(-1L, new TransientRegistry());
        Iterator it = this.getRegistries().iterator();
        while (it.hasNext()) {
            ((Registry)it.next()).initialise();
        }
    }

    public void dispose() {
        Iterator it = this.getRegistries().iterator();
        while (it.hasNext()) {
            ((Registry)it.next()).dispose();
        }
    }

    public String getRegistryId() {
        return this.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    protected abstract Collection getRegistries();

    public Object lookupObject(String key) {
        Object obj = null;
        Iterator it = this.getRegistries().iterator();
        while (obj == null && it.hasNext()) {
            obj = ((Registry)it.next()).lookupObject(key);
        }
        return obj;
    }

    public Object lookupObject(Class type) throws RegistrationException {
        Collection objects = this.lookupObjects(type);
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        if (objects.size() > 1) {
            throw new RegistrationException("More than one object of type " + type + " registered but only one expected.");
        }
        return null;
    }

    public Collection lookupObjects(Class type) {
        ArrayList objects = new ArrayList();
        Iterator it = this.getRegistries().iterator();
        while (it.hasNext()) {
            objects.addAll(((Registry)it.next()).lookupObjects(type));
        }
        return objects;
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        if (value instanceof MuleContextAware) {
            ((MuleContextAware)value).setMuleContext(MuleServer.getMuleContext());
        }
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly()) continue;
            reg.registerObject(key, value, metadata);
            break;
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        for (Object key : objects.keySet()) {
            this.registerObject((String)key, objects.get(key));
        }
    }

    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, null);
    }

    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly() || reg.lookupObject(key) == null) continue;
            reg.unregisterObject(key, metadata);
            break;
        }
    }
}

