/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.RegistryContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ServiceException;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.endpoint.URIBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.CharSetUtils;
import org.mule.util.ClassUtils;
import org.mule.util.MapCombiner;
import org.mule.util.ObjectNameHelper;

public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    public static final String PROPERTY_REMOTE_SYNC = "remoteSync";
    public static final String PROPERTY_REMOTE_SYNC_TIMEOUT = "remoteSyncTimeout";
    protected URIBuilder uriBuilder;
    protected Connector connector;
    protected List transformers;
    protected List responseTransformers;
    protected String name;
    protected Map properties = new HashMap();
    protected TransactionConfig transactionConfig;
    protected Filter filter;
    protected Boolean deleteUnacceptedMessages;
    protected EndpointSecurityFilter securityFilter;
    protected Boolean synchronous;
    protected Boolean remoteSync;
    protected Integer remoteSyncTimeout;
    protected String initialState = "started";
    protected String encoding;
    protected Integer createConnector;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected String registryId = null;
    protected MuleContext muleContext;

    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildInboundEndpoint();
    }

    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildOutboundEndpoint();
    }

    protected void setPropertiesFromProperties(Map properties) {
        this.synchronous = AbstractEndpointBuilder.getBooleanProperty(properties, "synchronous", this.synchronous);
        this.remoteSync = AbstractEndpointBuilder.getBooleanProperty(properties, PROPERTY_REMOTE_SYNC, this.remoteSync);
        this.remoteSyncTimeout = AbstractEndpointBuilder.getIntegerProperty(properties, PROPERTY_REMOTE_SYNC_TIMEOUT, this.remoteSyncTimeout);
    }

    public static Boolean getBooleanProperty(Map properties, String name, Boolean dflt) {
        if (properties.containsKey(name)) {
            return Boolean.valueOf((String)properties.get(name));
        }
        return dflt;
    }

    public static Integer getIntegerProperty(Map properties, String name, Integer dflt) {
        if (properties.containsKey(name)) {
            return Integer.decode((String)properties.get(name));
        }
        return dflt;
    }

    protected InboundEndpoint doBuildInboundEndpoint() throws InitialisationException, EndpointException {
        Map properties = this.getProperties();
        this.setPropertiesFromProperties(properties);
        if (this.uriBuilder == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("uriBuilder"));
        }
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        Connector connector = this.getConnector();
        if (connector != null && endpointURI != null && !connector.supportsProtocol(endpointURI.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        List transformers = this.getInboundTransformers(connector, endpointURI);
        List responseTransformers = this.getInboundEndpointResponseTransformers(connector, endpointURI);
        boolean remoteSync = this.getRemoteSync(connector);
        boolean synchronous = remoteSync ? true : this.getSynchronous(connector, endpointURI);
        return new DefaultInboundEndpoint(connector, endpointURI, transformers, responseTransformers, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getFilter(connector), this.getDefaultDeleteUnacceptedMessages(connector), this.getSecurityFilter(), synchronous, remoteSync, this.getRemoteSyncTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.muleContext, this.getRetryPolicyTemplate(connector));
    }

    protected OutboundEndpoint doBuildOutboundEndpoint() throws InitialisationException, EndpointException {
        Map properties = this.getProperties();
        this.setPropertiesFromProperties(properties);
        if (this.uriBuilder == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("uriBuilder"));
        }
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        Connector connector = this.getConnector();
        if (connector != null && endpointURI != null && !connector.supportsProtocol(endpointURI.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        List transformers = this.getOutboundTransformers(connector, endpointURI);
        List responseTransformers = this.getOutboundEndpointResponseTransformers(connector, endpointURI);
        boolean remoteSync = this.getRemoteSync(connector);
        boolean synchronous = remoteSync ? true : this.getSynchronous(connector, endpointURI);
        return new DefaultOutboundEndpoint(connector, endpointURI, transformers, responseTransformers, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getFilter(connector), this.getDefaultDeleteUnacceptedMessages(connector), this.getSecurityFilter(), synchronous, remoteSync, this.getRemoteSyncTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.muleContext, this.getRetryPolicyTemplate(connector));
    }

    protected boolean getSynchronous(Connector connector, EndpointURI endpointURI) {
        return this.synchronous != null ? this.synchronous.booleanValue() : this.getDefaultSynchronous(connector, endpointURI.getScheme());
    }

    protected boolean getDefaultSynchronous(Connector connector, String protocol) {
        if (connector != null && connector.isSyncEnabled(protocol)) {
            return true;
        }
        return this.muleContext.getConfiguration().isDefaultSynchronousEndpoints();
    }

    protected RetryPolicyTemplate getRetryPolicyTemplate(Connector connector) {
        return this.retryPolicyTemplate != null ? this.retryPolicyTemplate : connector.getRetryPolicyTemplate();
    }

    protected TransactionConfig getTransactionConfig() {
        return this.transactionConfig != null ? this.transactionConfig : this.getDefaultTransactionConfig();
    }

    protected TransactionConfig getDefaultTransactionConfig() {
        return new MuleTransactionConfig();
    }

    protected EndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter != null ? this.securityFilter : this.getDefaultSecurityFilter();
    }

    protected EndpointSecurityFilter getDefaultSecurityFilter() {
        return null;
    }

    protected Connector getConnector() throws EndpointException {
        return this.connector != null ? this.connector : this.getDefaultConnector();
    }

    protected Connector getDefaultConnector() throws EndpointException {
        return this.getConnector(this.uriBuilder.getEndpoint(), this.muleContext);
    }

    protected String getName(EndpointURI endpointURI) {
        return this.name != null ? this.name : ObjectNameHelper.getEndpointName(endpointURI);
    }

    protected Map getProperties() {
        LinkedList<Map> maps = new LinkedList<Map>();
        if (null != this.uriBuilder) {
            maps.addLast(this.uriBuilder.getEndpoint().getParams());
        }
        if (this.properties != null) {
            maps.addLast(this.properties);
        }
        MapCombiner combiner = new MapCombiner();
        combiner.setList(maps);
        return Collections.unmodifiableMap(combiner);
    }

    protected boolean getRemoteSync(Connector connector) {
        return this.remoteSync != null ? this.remoteSync.booleanValue() : this.getDefaultRemoteSync(connector);
    }

    protected boolean getDefaultRemoteSync(Connector connector) {
        return this.muleContext.getConfiguration().isDefaultRemoteSync();
    }

    protected boolean getDeleteUnacceptedMessages(Connector connector) {
        return this.deleteUnacceptedMessages != null ? this.deleteUnacceptedMessages.booleanValue() : this.getDefaultDeleteUnacceptedMessages(connector);
    }

    protected boolean getDefaultDeleteUnacceptedMessages(Connector connector) {
        return false;
    }

    protected String getEndpointEncoding(Connector connector) {
        return this.encoding != null ? this.encoding : this.getDefaultEndpointEncoding(connector);
    }

    protected String getDefaultEndpointEncoding(Connector connector) {
        if (this.muleContext != null) {
            return this.muleContext.getConfiguration().getDefaultEncoding();
        }
        return CharSetUtils.defaultCharsetName();
    }

    protected Filter getFilter(Connector connector) {
        return this.filter != null ? this.filter : this.getDefaultFilter(connector);
    }

    protected Filter getDefaultFilter(Connector connector) {
        return null;
    }

    protected String getInitialState(Connector connector) {
        return this.initialState != null ? this.initialState : this.getDefaultInitialState(connector);
    }

    protected String getDefaultInitialState(Connector connector) {
        return "started";
    }

    protected int getRemoteSyncTimeout(Connector connector) {
        return this.remoteSyncTimeout != null ? this.remoteSyncTimeout.intValue() : this.getDefaultRemoteSyncTimeout(connector);
    }

    protected int getDefaultRemoteSyncTimeout(Connector connector) {
        return this.muleContext.getConfiguration().getDefaultSynchronousEventTimeout();
    }

    protected List getInboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.transformers != null) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultInboundTransformers(connector);
    }

    protected List getDefaultInboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultInboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getOutboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.transformers != null) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultOutboundTransformers(connector);
    }

    protected List getDefaultOutboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultOutboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getInboundEndpointResponseTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.responseTransformers != null) {
            return this.responseTransformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (transformers != null) {
            return transformers;
        }
        return this.getDefaultResponseTransformers(connector);
    }

    protected List getOutboundEndpointResponseTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (this.responseTransformers != null) {
            return this.responseTransformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (transformers != null) {
            return transformers;
        }
        return Collections.EMPTY_LIST;
    }

    protected List getDefaultResponseTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultResponseTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    private List getTransformersFromString(String transformers) throws TransportFactoryException {
        try {
            return TransformerUtils.getTransformers(transformers);
        }
        catch (DefaultMuleException e) {
            throw new TransportFactoryException(e);
        }
    }

    private Properties getOverrides(Connector connector) {
        Map so;
        Properties overrides = new Properties();
        if (connector instanceof AbstractConnector && (so = ((AbstractConnector)connector).getServiceOverrides()) != null) {
            overrides.putAll((Map<?, ?>)so);
        }
        return overrides;
    }

    private TransportServiceDescriptor getNonNullServiceDescriptor(String scheme, Properties overrides) throws ServiceException {
        TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, overrides);
        if (null != sd) {
            return sd;
        }
        throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
    }

    private Connector getConnector(EndpointURI endpointURI, MuleContext muleContext) throws EndpointException {
        Connector connector;
        String scheme = this.uriBuilder.getEndpoint().getFullScheme();
        try {
            if (this.uriBuilder.getEndpoint().getConnectorName() != null) {
                connector = muleContext.getRegistry().lookupConnector(this.uriBuilder.getEndpoint().getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", this.uriBuilder.getEndpoint().getConnectorName()));
                }
            } else {
                connector = TransportFactory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = TransportFactory.createConnector(endpointURI, muleContext);
                    muleContext.getRegistry().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "endpointURI: " + endpointURI);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        return connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void addTransformer(Transformer transformer) {
        if (this.transformers == null) {
            this.transformers = new LinkedList();
        }
        this.transformers.add(transformer);
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }

    public void setResponseTransformers(List responseTransformers) {
        this.responseTransformers = responseTransformers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map properties) {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        this.properties.putAll(properties);
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setDeleteUnacceptedMessages(boolean deleteUnacceptedMessages) {
        this.deleteUnacceptedMessages = deleteUnacceptedMessages;
    }

    public void setSecurityFilter(EndpointSecurityFilter securityFilter) {
        this.securityFilter = securityFilter;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setRemoteSync(boolean remoteSync) {
        this.remoteSync = remoteSync;
    }

    public void setRemoteSyncTimeout(int remoteSyncTimeout) {
        this.remoteSyncTimeout = new Integer(remoteSyncTimeout);
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCreateConnector(int createConnector) {
        this.createConnector = new Integer(createConnector);
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public URIBuilder getEndpointBuilder() {
        return this.uriBuilder;
    }

    public void setURIBuilder(URIBuilder URIBuilder2) {
        this.uriBuilder = URIBuilder2;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.retryPolicyTemplate, this.connector, this.createConnector, this.deleteUnacceptedMessages, this.encoding, this.uriBuilder, this.filter, this.initialState, this.name, this.properties, this.remoteSync, this.remoteSyncTimeout, this.responseTransformers, this.securityFilter, this.synchronous, this.transactionConfig, this.transformers});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpointBuilder other = (AbstractEndpointBuilder)obj;
        return AbstractEndpointBuilder.equal(this.retryPolicyTemplate, other.retryPolicyTemplate) && AbstractEndpointBuilder.equal(this.connector, other.connector) && AbstractEndpointBuilder.equal(this.createConnector, other.createConnector) && AbstractEndpointBuilder.equal(this.deleteUnacceptedMessages, other.deleteUnacceptedMessages) && AbstractEndpointBuilder.equal(this.encoding, other.encoding) && AbstractEndpointBuilder.equal(this.uriBuilder, other.uriBuilder) && AbstractEndpointBuilder.equal(this.filter, other.filter) && AbstractEndpointBuilder.equal(this.initialState, other.initialState) && AbstractEndpointBuilder.equal(this.name, other.name) && AbstractEndpointBuilder.equal(this.properties, other.properties) && AbstractEndpointBuilder.equal(this.remoteSync, other.remoteSync) && AbstractEndpointBuilder.equal(this.remoteSyncTimeout, other.remoteSyncTimeout) && AbstractEndpointBuilder.equal(this.responseTransformers, other.responseTransformers) && AbstractEndpointBuilder.equal(this.securityFilter, other.securityFilter) && AbstractEndpointBuilder.equal(this.synchronous, other.synchronous) && AbstractEndpointBuilder.equal(this.transactionConfig, other.transactionConfig) && AbstractEndpointBuilder.equal(this.transformers, other.transformers);
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointBuilder builder = (EndpointBuilder)super.clone();
        builder.setConnector(this.connector);
        builder.setURIBuilder(this.uriBuilder);
        builder.setTransformers(this.transformers);
        builder.setResponseTransformers(this.responseTransformers);
        builder.setName(this.name);
        builder.setProperties(this.properties);
        builder.setTransactionConfig(this.transactionConfig);
        builder.setFilter(this.filter);
        builder.setSecurityFilter(this.securityFilter);
        builder.setInitialState(this.initialState);
        builder.setEncoding(this.encoding);
        builder.setRegistryId(this.registryId);
        builder.setMuleContext(this.muleContext);
        builder.setRetryPolicyTemplate(this.retryPolicyTemplate);
        if (this.deleteUnacceptedMessages != null) {
            builder.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        }
        if (this.synchronous != null) {
            builder.setSynchronous(this.synchronous);
        }
        if (this.remoteSync != null) {
            builder.setRemoteSync(this.remoteSync);
        }
        if (this.remoteSyncTimeout != null) {
            builder.setRemoteSyncTimeout(this.remoteSyncTimeout);
        }
        return builder;
    }
}

