/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.MuleContext;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;

public class MuleContextNotification
extends ServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = -3246036188011581121L;
    public static final int CONTEXT_INITIALISING = 101;
    public static final int CONTEXT_INITIALISED = 102;
    public static final int CONTEXT_STARTING = 103;
    public static final int CONTEXT_STARTED = 104;
    public static final int CONTEXT_STOPPING = 105;
    public static final int CONTEXT_STOPPED = 106;
    public static final int CONTEXT_DISPOSING = 107;
    public static final int CONTEXT_DISPOSED = 108;
    public static final int CONTEXT_DISPOSING_CONNECTORS = 109;
    public static final int CONTEXT_DISPOSED_CONNECTORS = 110;
    public static final int CONTEXT_STARTING_MODELS = 111;
    public static final int CONTEXT_STARTED_MODELS = 112;
    public static final int CONTEXT_STOPPING_MODELS = 113;
    public static final int CONTEXT_STOPPED_MODELS = 114;
    private String clusterId;
    private String domain;

    public MuleContextNotification(MuleContext context, String action) {
        this(context, MuleContextNotification.getActionId(action));
    }

    public MuleContextNotification(MuleContext context, int action) {
        super(MuleContextNotification.getId(context), action);
        this.resourceIdentifier = MuleContextNotification.getId(context);
        this.clusterId = context.getConfiguration().getClusterId();
        this.domain = context.getConfiguration().getDomainId();
    }

    private static String getId(MuleContext context) {
        return context.getConfiguration().getDomainId() + "." + context.getConfiguration().getClusterId() + "." + context.getConfiguration().getId();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDomain() {
        return this.domain;
    }

    protected String getPayloadToString() {
        return ((MuleContext)this.source).getConfiguration().getId();
    }

    public String toString() {
        return this.EVENT_NAME + "{" + "action=" + MuleContextNotification.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + "}";
    }

    static {
        MuleContextNotification.registerAction("mule context initialising", 101);
        MuleContextNotification.registerAction("mule context initialised", 102);
        MuleContextNotification.registerAction("mule context starting", 103);
        MuleContextNotification.registerAction("mule context started", 104);
        MuleContextNotification.registerAction("mule context stopping", 105);
        MuleContextNotification.registerAction("mule context stopped", 106);
        MuleContextNotification.registerAction("mule context disposing", 107);
        MuleContextNotification.registerAction("mule context disposed", 108);
        MuleContextNotification.registerAction("disposing connectors", 109);
        MuleContextNotification.registerAction("disposed connectors", 110);
        MuleContextNotification.registerAction("starting models", 111);
        MuleContextNotification.registerAction("started models", 112);
        MuleContextNotification.registerAction("stopping models", 113);
        MuleContextNotification.registerAction("stopped models", 114);
    }
}

