/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component.builder;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.MuleMessage;
import org.mule.component.builder.AbstractMessageBuilder;
import org.mule.component.builder.MessageBuilderException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.util.ClassUtils;

public class ReflectionMessageBuilder
extends AbstractMessageBuilder {
    protected final Set ignoreMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));

    public Object buildMessage(MuleMessage request, MuleMessage response) throws MessageBuilderException {
        Object master = request.getPayload();
        Object property = response.getPayload();
        List methods = null;
        try {
            methods = ClassUtils.getSatisfiableMethods(master.getClass(), new Class[]{property.getClass()}, true, false, this.ignoreMethods);
        }
        catch (Exception e) {
            throw new MessageBuilderException(request, (Throwable)e);
        }
        if (methods.isEmpty()) {
            throw new MessageBuilderException(request, (Throwable)new NoSatisfiableMethodsException(master, new Class[]{property.getClass()}));
        }
        if (methods.size() > 1) {
            throw new MessageBuilderException(request, (Throwable)new TooManySatisfiableMethodsException(master, new String[]{property.getClass().getName()}));
        }
        Method m = (Method)methods.get(0);
        try {
            Object[] objectArray;
            if (property.getClass().isArray()) {
                objectArray = (Object[])property;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = property;
            }
            m.invoke(master, objectArray);
        }
        catch (Exception e) {
            throw new MessageBuilderException(CoreMessages.failedToInvoke(m.getName() + " on " + master.getClass().getName()), request, (Throwable)e);
        }
        return master;
    }
}

