/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.transport;

import java.io.Serializable;
import java.util.Comparator;

public final class PropertyScope
implements Serializable {
    private static final long serialVersionUID = -4792653762048974018L;
    public static final String INVOCATION_NAME = "invocation";
    public static final String INBOUND_NAME = "inbound";
    public static final String OUTBOUND_NAME = "outbound";
    public static final String SESSION_NAME = "session";
    public static final String APPLICATION_NAME = "application";
    public static final PropertyScope INVOCATION = new PropertyScope("invocation", 0);
    public static final PropertyScope INBOUND = new PropertyScope("inbound", 1);
    public static final PropertyScope OUTBOUND = new PropertyScope("outbound", 2);
    public static final PropertyScope SESSION = new PropertyScope("session", 3);
    public static final PropertyScope APPLICATION = new PropertyScope("application", 4);
    public static final PropertyScope[] ALL_SCOPES = new PropertyScope[]{INVOCATION, INBOUND, OUTBOUND, SESSION, APPLICATION};
    private String scope;
    private int order;

    public PropertyScope(String scope, int order) {
        this.scope = scope;
        this.order = order;
    }

    public String getScope() {
        return this.scope;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return this.getScope();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyScope that = (PropertyScope)o;
        if (this.order != that.order) {
            return false;
        }
        return !(this.scope != null ? !this.scope.equals(that.scope) : that.scope != null);
    }

    public int hashCode() {
        int result = this.scope != null ? this.scope.hashCode() : 0;
        result = 31 * result + this.order;
        return result;
    }

    public static class ScopeComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -3346258000312580166L;

        public int compare(Object o, Object o1) {
            if (o == o1) {
                return 0;
            }
            if (o.equals(o1)) {
                return 0;
            }
            return ((PropertyScope)o).getOrder() < ((PropertyScope)o1).getOrder() ? -1 : 1;
        }
    }
}

