/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.expression.ExpressionEvaluator;
import org.mule.util.expression.ExpressionRuntimeException;

public class MessageHeadersListExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "headers-list";
    public static final String DELIM = ",";

    public Object evaluate(String expression, Object message) {
        boolean required = false;
        if (expression.endsWith("required")) {
            required = true;
            expression = expression.substring(0, expression.length() - 8);
        }
        if (message instanceof MessageAdapter) {
            StringTokenizer tokenizer = new StringTokenizer(expression, DELIM);
            ArrayList<Object> result = new ArrayList<Object>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                Object val = ((MessageAdapter)message).getProperty(s = s.trim());
                if (val != null) {
                    result.add(val);
                    continue;
                }
                if (!required) continue;
                throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

