/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.transport.Connectable;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnectionStrategy;
import org.mule.transport.FatalConnectException;
import org.mule.util.ObjectUtils;

public class SimpleRetryConnectionStrategy
extends AbstractConnectionStrategy {
    public static final int DEFAULT_FREQUENCY = 2000;
    public static final int DEFAULT_RETRY_COUNT = 2;
    public static final int RETRY_COUNT_FOREVER = -1;
    protected static final RetryCounter retryCounter = new RetryCounter();
    protected static final ThreadLocal called = new ThreadLocal();
    private volatile int retryCount = 2;
    private volatile long retryFrequency = 2000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect(Connectable connectable) throws FatalConnectException {
        while (true) {
            Boolean recursiveCallDetected;
            if (!(recursiveCallDetected = (Boolean)ObjectUtils.defaultIfNull(called.get(), (Object)Boolean.FALSE)).booleanValue()) {
                retryCounter.countRetry();
            }
            called.set(Boolean.TRUE);
            try {
                connectable.connect();
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Successfully connected to " + this.getDescription(connectable)));
            }
            catch (InterruptedException ie) {
                throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), (Throwable)ie, connectable);
            }
            catch (Exception e) {
                if (e instanceof FatalConnectException) {
                    throw (FatalConnectException)e;
                }
                if (this.retryCount != -1 && retryCounter.current().get() >= this.retryCount) {
                    throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), (Throwable)e, connectable);
                }
                if (this.logger.isErrorEnabled()) {
                    StringBuffer msg = new StringBuffer(512);
                    msg.append("Failed to connect/reconnect: ").append(this.getDescription(connectable));
                    Throwable t = ExceptionHelper.getRootException(e);
                    msg.append(". Root Exception was: ").append(ExceptionHelper.writeException(t));
                    this.logger.error((Object)msg.toString(), (Throwable)e);
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Waiting for " + this.retryFrequency + "ms before reconnecting. Failed attempt " + retryCounter.current().get() + " of " + (this.retryCount != -1 ? String.valueOf(this.retryCount) : "unlimited")));
                }
                try {
                    Thread.sleep(this.retryFrequency);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), (Throwable)e, connectable);
                }
            }
            finally {
                called.set(Boolean.FALSE);
                continue;
            }
            break;
        }
    }

    public synchronized void resetState() {
        retryCounter.reset();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getRetryFrequency() {
        return this.retryFrequency;
    }

    public void setRetryFrequency(long retryFrequency) {
        this.retryFrequency = retryFrequency;
    }

    protected static class RetryCounter
    extends ThreadLocal {
        protected RetryCounter() {
        }

        public int countRetry() {
            return ((AtomicInteger)this.get()).incrementAndGet();
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        protected Object initialValue() {
            return new AtomicInteger(0);
        }
    }
}

