/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;
import org.mule.util.XMLEntityCodec;

public class XmlEntityDecoder
extends AbstractTransformer {
    public XmlEntityDecoder() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            String data = src instanceof byte[] ? new String((byte[])src, encoding) : (src instanceof InputStream ? IOUtils.toString((InputStream)src) : (String)src);
            return XMLEntityCodec.decodeString(data);
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "XML"), this, (Throwable)ex);
        }
    }
}

