/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.RoutingException;
import org.mule.routing.inbound.SelectiveConsumer;

public class ForwardingConsumer
extends SelectiveConsumer {
    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        if (super.process(event) != null) {
            OutboundRouterCollection router = event.getService().getOutboundRouter();
            event.setStopFurtherProcessing(true);
            if (router == null) {
                this.logger.debug((Object)"Descriptor has no outbound router configured to forward to, continuing with normal processing");
                return new MuleEvent[]{event};
            }
            try {
                DefaultMuleMessage message = new DefaultMuleMessage(event.transformMessage(), event.getMessage());
                MuleMessage response = router.route(message, event.getSession(), event.isSynchronous());
                if (response != null) {
                    return new MuleEvent[]{new DefaultMuleEvent(response, event)};
                }
                return null;
            }
            catch (MuleException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return null;
    }
}

