/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import edu.emory.mathcs.backport.java.util.Collections;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.api.transport.Connector;
import org.mule.util.ClassUtils;

public abstract class AbstractEndpoint
implements ImmutableEndpoint {
    private static final long serialVersionUID = -1650380871293160973L;
    protected static final Log logger = LogFactory.getLog(AbstractEndpoint.class);
    private final Connector connector;
    private final EndpointURI endpointUri;
    private final List transformers;
    private final List responseTransformers;
    private final String name;
    private Map properties = new HashMap();
    private final TransactionConfig transactionConfig;
    private final Filter filter;
    private final boolean deleteUnacceptedMessages;
    private final EndpointSecurityFilter securityFilter;
    private final boolean synchronous;
    private final boolean remoteSync;
    private final int remoteSyncTimeout;
    private final String initialState;
    private final String endpointEncoding;
    private final MuleContext muleContext;
    private final ConnectionStrategy connectionStrategy;

    public AbstractEndpoint(Connector connector, EndpointURI endpointUri, List transformers, List responseTransformers, String name, Map properties, TransactionConfig transactionConfig, Filter filter, boolean deleteUnacceptedMessages, EndpointSecurityFilter securityFilter, boolean synchronous, boolean remoteSync, int remoteSyncTimeout, String initialState, String endpointEncoding, MuleContext muleContext, ConnectionStrategy connectionStrategy) {
        this.connector = connector;
        this.endpointUri = endpointUri;
        if (transformers == null) {
            this.transformers = Collections.unmodifiableList((List)java.util.Collections.EMPTY_LIST);
        } else {
            this.updateTransformerEndpoints(transformers);
            this.transformers = Collections.unmodifiableList((List)transformers);
        }
        if (responseTransformers == null) {
            this.responseTransformers = Collections.unmodifiableList((List)java.util.Collections.EMPTY_LIST);
        } else {
            this.updateTransformerEndpoints(responseTransformers);
            this.responseTransformers = Collections.unmodifiableList((List)responseTransformers);
        }
        this.name = name;
        this.properties.putAll(properties);
        this.transactionConfig = transactionConfig;
        this.filter = filter;
        this.deleteUnacceptedMessages = deleteUnacceptedMessages;
        this.securityFilter = securityFilter;
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
        }
        this.synchronous = synchronous;
        this.remoteSync = remoteSync;
        this.remoteSyncTimeout = remoteSyncTimeout;
        this.initialState = initialState;
        this.endpointEncoding = endpointEncoding;
        this.muleContext = muleContext;
        this.connectionStrategy = connectionStrategy;
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getEncoding() {
        return this.endpointEncoding;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public List getTransformers() {
        return this.transformers;
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = new StringBuffer(uri.getScheme()).append("://").append(sanitizerMatcher.group(1)).append(":<password>").append("@").append(uri.getHost()).append(uri.getRawPath()).toString();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ", transformer=" + this.transformers + ", name='" + this.name + "'" + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", initialState=" + this.initialState + ", remoteSync=" + this.remoteSync + ", remoteSyncTimeout=" + this.remoteSyncTimeout + ", endpointEncoding=" + this.endpointEncoding + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpoint other = (AbstractEndpoint)obj;
        return AbstractEndpoint.equal(this.connectionStrategy, other.connectionStrategy) && AbstractEndpoint.equal(this.connector, other.connector) && this.deleteUnacceptedMessages == other.deleteUnacceptedMessages && AbstractEndpoint.equal(this.endpointEncoding, other.endpointEncoding) && AbstractEndpoint.equal(this.endpointUri, other.endpointUri) && AbstractEndpoint.equal(this.filter, other.filter) && AbstractEndpoint.equal(this.initialState, other.initialState) && AbstractEndpoint.equal(this.name, other.name) && AbstractEndpoint.equal(this.properties, other.properties) && this.remoteSync == other.remoteSync && this.remoteSyncTimeout == other.remoteSyncTimeout && AbstractEndpoint.equal(this.responseTransformers, other.responseTransformers) && AbstractEndpoint.equal(this.securityFilter, other.securityFilter) && this.synchronous == other.synchronous && AbstractEndpoint.equal(this.transactionConfig, other.transactionConfig) && AbstractEndpoint.equal(this.transformers, other.transformers);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.connectionStrategy, this.connector, this.deleteUnacceptedMessages ? Boolean.TRUE : Boolean.FALSE, this.endpointEncoding, this.endpointUri, this.filter, this.initialState, this.name, this.properties, this.remoteSync ? Boolean.TRUE : Boolean.FALSE, new Integer(this.remoteSyncTimeout), this.responseTransformers, this.securityFilter, this.synchronous ? Boolean.TRUE : Boolean.FALSE, this.transactionConfig, this.transformers});
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    protected void updateTransformerEndpoints(List transformers) {
        Iterator transformer = transformers.iterator();
        while (transformer.hasNext()) {
            ((Transformer)transformer.next()).setEndpoint(this);
        }
    }

    public EndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isRemoteSync() {
        return this.remoteSync;
    }

    public int getRemoteSyncTimeout() {
        return this.remoteSyncTimeout;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public List getResponseTransformers() {
        return this.responseTransformers;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }
}

