/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleSession;
import org.mule.RegistryContext;
import org.mule.ResponseOutputStream;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.security.Credentials;
import org.mule.api.service.Service;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.MuleCredentials;
import org.mule.util.MapUtils;
import org.mule.util.UUID;

public class DefaultMuleEvent
extends EventObject
implements MuleEvent,
ThreadSafeAccess {
    private static final long serialVersionUID = 1L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient ImmutableEndpoint endpoint = null;
    private String id = null;
    private MuleMessage message = null;
    private transient MuleSession session;
    private boolean stopFurtherProcessing = false;
    private boolean synchronous = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream = null;
    private transient Object transformedMessage = null;
    private Credentials credentials = null;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, Service service, MuleEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        ((DefaultMuleSession)this.session).setService(service);
        this.endpoint = endpoint;
        this.synchronous = previousEvent.isSynchronous();
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.fillProperties(previousEvent);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, boolean synchronous) {
        this(message, endpoint, session, synchronous, null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, boolean synchronous, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.synchronous = synchronous;
        this.outputStream = outputStream;
        this.fillProperties(null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, String eventId, boolean synchronous) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = eventId;
        this.synchronous = synchronous;
        this.fillProperties(null);
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        ((DefaultMuleSession)this.session).setService(rewriteEvent.getService());
        this.endpoint = rewriteEvent.getEndpoint();
        this.synchronous = rewriteEvent.isSynchronous();
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof DefaultMuleEvent) {
            this.transformedMessage = ((DefaultMuleEvent)rewriteEvent).getCachedMessage();
        }
        this.fillProperties(rewriteEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillProperties(MuleEvent previousEvent) {
        if (previousEvent != null) {
            MuleMessage msg;
            MuleMessage muleMessage = msg = previousEvent.getMessage();
            synchronized (muleMessage) {
                for (String prop : msg.getPropertyNames()) {
                    Object value = msg.getProperty(prop);
                    if (this.ignoreProperty(prop)) continue;
                    this.message.setProperty(prop, value);
                }
            }
        }
        if (this.endpoint != null && this.endpoint.getProperties() != null) {
            for (String prop : this.endpoint.getProperties().keySet()) {
                Object value = this.endpoint.getProperties().get(prop);
                if (this.ignoreProperty(prop)) continue;
                this.message.setProperty(prop, value, PropertyScope.INVOCATION);
            }
        }
        this.setCredentials();
    }

    protected boolean ignoreProperty(String key) {
        if (key == null) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getProperty(key);
    }

    protected void setCredentials() {
        if (null != this.endpoint && null != this.endpoint.getEndpointURI() && null != this.endpoint.getEndpointURI().getUserInfo()) {
            String userName = this.endpoint.getEndpointURI().getUser();
            String password = this.endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                this.credentials = new MuleCredentials(userName, password.toCharArray());
            }
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    public MuleMessage getMessage() {
        return this.message;
    }

    public byte[] getMessageAsBytes() throws DefaultMuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    public Object transformMessage() throws TransformerException {
        return this.transformMessage(null);
    }

    public Object transformMessage(Class outputType) throws TransformerException {
        this.message.applyTransformers(this.endpoint.getTransformers());
        if (outputType == null) {
            return this.message.getPayload();
        }
        return this.message.getPayload(outputType);
    }

    public byte[] transformMessageToBytes() throws TransformerException {
        Object obj = this.transformMessage(byte[].class);
        return (byte[])obj;
    }

    public String transformMessageToString() throws TransformerException {
        try {
            return new String(this.transformMessageToBytes(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.endpoint.getTransformers(), (Throwable)e);
        }
    }

    public String getMessageAsString() throws MuleException {
        return this.getMessageAsString(this.getEncoding());
    }

    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name, boolean exhaustiveSearch) {
        return this.getProperty(name, null, exhaustiveSearch);
    }

    public Object getProperty(String name, Object defaultValue, boolean exhaustiveSearch) {
        Object property = this.message.getProperty(name);
        if (exhaustiveSearch) {
            if (property == null) {
                property = MapUtils.getObject((Map)this.getEndpoint().getEndpointURI().getParams(), (Object)name, null);
            }
            if (property == null) {
                try {
                    property = PropertyUtils.getProperty((Object)this.getEndpoint().getConnector(), (String)name);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return property == null ? defaultValue : property;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("MuleEvent: ").append(this.getId());
        buf.append(", sync=").append(this.isSynchronous());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return UUID.getUUID();
    }

    public MuleSession getSession() {
        return this.session;
    }

    void setSession(MuleSession session) {
        this.session = session;
    }

    public Service getService() {
        return this.session.getService();
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMuleEvent)) {
            return false;
        }
        DefaultMuleEvent event = (DefaultMuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            this.timeout = this.endpoint.getRemoteSyncTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.endpoint.hashCode());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.logger = LogFactory.getLog(this.getClass());
        in.defaultReadObject();
        int hashCode = in.readInt();
        this.endpoint = (ImmutableEndpoint)RegistryContext.getRegistry().lookupObject("endpoint:" + hashCode);
    }

    public String getEncoding() {
        String encoding = this.message.getEncoding();
        if (encoding == null) {
            encoding = this.endpoint.getEncoding();
        }
        return encoding;
    }

    public MuleContext getMuleContext() {
        return this.endpoint.getMuleContext();
    }

    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }
}

