/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.resource.spi.work.WorkListener;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.agent.Agent;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.management.stats.AllStatistics;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    private static transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    private WorkListener workListener;
    protected LifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;

    public DefaultMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, LifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        this.workManager = workManager;
        this.workListener = workListener;
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
    }

    public void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("_muleNotificationManager").getMessage());
        }
        if (this.workManager == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("workManager").getMessage());
        }
        try {
            this.workManager.start();
            this.getNotificationManager().start(this.workManager, this.workListener);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.lifecycleManager.firePhase(this, "initialise");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void start() throws MuleException {
        this.lifecycleManager.checkPhase("start");
        if (!this.isStarted()) {
            if (this.getSecurityManager() == null) {
                throw new NullPointerException(CoreMessages.objectIsNull("securityManager").getMessage());
            }
            if (this.getQueueManager() == null) {
                throw new NullPointerException(CoreMessages.objectIsNull("queueManager").getMessage());
            }
            this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
            this.lifecycleManager.firePhase(this, "start");
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.getStartSplash());
            }
            this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
        }
        this.startDate = System.currentTimeMillis();
    }

    public synchronized void stop() throws MuleException {
        this.lifecycleManager.checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.lifecycleManager.firePhase(this, "stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    public void dispose() {
        if (this.isDisposing()) {
            return;
        }
        ServerNotificationManager notificationManager = this.getNotificationManager();
        this.lifecycleManager.checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        try {
            if (this.isStarted()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            logger.error((Object)("Failed to stop manager: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.lifecycleManager.firePhase(this, "dispose");
        }
        catch (MuleException e) {
            logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        if (this.getStartDate() > 0L && logger.isInfoEnabled()) {
            logger.info((Object)this.getEndSplash());
        }
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected boolean isStopped() {
        return this.lifecycleManager.isPhaseComplete("stop");
    }

    protected boolean isStopping() {
        return "stop".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isStarted() {
        return this.lifecycleManager.isPhaseComplete("start");
    }

    protected boolean isStarting() {
        return "start".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.getRegistry().registerObject("_muleSecurityManager", securityManager);
    }

    public SecurityManager getSecurityManager() {
        Collection temp;
        SecurityManager securityManager = (SecurityManager)this.getRegistry().lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.getRegistry().lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = (SecurityManager)temp.iterator().next();
        }
        return securityManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public QueueManager getQueueManager() {
        Collection temp;
        QueueManager queueManager = (QueueManager)this.getRegistry().lookupObject("_muleQueueManager");
        if (queueManager == null && (temp = this.getRegistry().lookupObjects(QueueManager.class)).size() > 0) {
            queueManager = (QueueManager)temp.iterator().next();
        }
        return queueManager;
    }

    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleQueueManager", "initialise");
        this.getRegistry().registerObject("_muleQueueManager", queueManager);
    }

    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.getRegistry().registerObject("_muleTransactionManager", manager);
    }

    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.getRegistry().lookupObject("_muleTransactionManager");
        if (transactionManager == null) {
            Collection temp = this.getRegistry().lookupObjects(TransactionManagerFactory.class);
            if (temp.size() > 0) {
                try {
                    transactionManager = ((TransactionManagerFactory)temp.iterator().next()).create();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage("Unable to create transaction manager"));
                }
            } else {
                temp = this.getRegistry().lookupObjects(TransactionManager.class);
                if (temp.size() > 0) {
                    transactionManager = (TransactionManager)temp.iterator().next();
                }
            }
        }
        return transactionManager;
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has been gone through the " + phase + " phase.");
        }
    }

    public Registry getRegistry() {
        return RegistryContext.getRegistry();
    }

    public void applyLifecycle(Object object) throws MuleException {
        this.lifecycleManager.applyLifecycle(this, object);
    }

    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageDispatcherThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageRequesterThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageReceiverThreadingProfile");
    }

    public ThreadingProfile getDefaultComponentThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultComponentThreadingProfile");
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultThreadingProfile");
    }

    public ConnectionStrategy getDefaultConnectionStrategy() {
        ConnectionStrategy defaultConnectionStrategy = (ConnectionStrategy)this.getRegistry().lookupObject("_defaultConnectionStrategy");
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)defaultConnectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone("Connection Strategy"), (Throwable)e);
        }
    }

    public long getStartDate() {
        return this.startDate;
    }

    public String getStartSplash() {
        String notset = CoreMessages.notSet().getMessage();
        ArrayList<String> message = new ArrayList<String>();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            message.add(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            message.add(CoreMessages.version().getMessage() + " Build: " + StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            message.add(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            message.add(CoreMessages.versionNotSet().getMessage());
        }
        message.add(" ");
        message.add(CoreMessages.serverStartedAt(this.startDate).getMessage());
        message.add("Server ID: " + this.getConfiguration().getId());
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        String patch = System.getProperty("sun.os.patch.level", null);
        message.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = InetAddress.getLocalHost();
            message.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        message.add(" ");
        Collection agents = RegistryContext.getRegistry().lookupObjects(Agent.class);
        if (agents.size() == 0) {
            message.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            message.add(CoreMessages.agentsRunning().getMessage());
            for (Agent umoAgent : agents) {
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageUtils.getBoilerPlate(message, '*', 70);
    }

    public String getEndSplash() {
        ArrayList<String> message = new ArrayList<String>(2);
        long currentTime = System.currentTimeMillis();
        message.add(CoreMessages.shutdownNormally(new Date()).getMessage());
        long duration = 10L;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add(CoreMessages.serverWasUpForDuration(duration).getMessage());
        return StringMessageUtils.getBoilerPlate(message, '*', 78);
    }
}

