/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.nested;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.NestedRouter;
import org.mule.api.routing.OutboundRouter;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractRouter;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.routing.outbound.OutboundPassThroughRouter;

public class DefaultNestedRouter
extends AbstractRouter
implements NestedRouter {
    protected static Log logger = LogFactory.getLog(DefaultNestedRouter.class);
    private Class interfaceClass;
    private String methodName;
    protected OutboundRouter outboundRouter;

    public DefaultNestedRouter() {
        this.setRouterStatistics(new RouterStatistics(4));
    }

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws MessagingException {
        return this.outboundRouter.route(message, session, synchronous);
    }

    public void setInterface(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class getInterface() {
        return this.interfaceClass;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public Object createProxy(Object target) {
        try {
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, (InvocationHandler)new NestedInvocationHandler(this));
            logger.debug((Object)("Have proxy?: " + (null != proxy)));
            return proxy;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void setEndpoint(OutboundEndpoint e) {
        this.outboundRouter = new OutboundPassThroughRouter();
        this.outboundRouter.addEndpoint(e);
        this.outboundRouter.setTransactionConfig(e.getTransactionConfig());
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DefaultNestedRouter");
        sb.append("{method='").append(this.methodName).append('\'');
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }

    public OutboundEndpoint getEndpoint() {
        if (this.outboundRouter != null) {
            return (OutboundEndpoint)this.outboundRouter.getEndpoints().get(0);
        }
        return null;
    }
}

