/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.InvalidEndpointTypeException;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class DefaultInboundRouterCollection
extends AbstractRouterCollection
implements InboundRouterCollection {
    private final List endpoints = new CopyOnWriteArrayList();

    public DefaultInboundRouterCollection() {
        super(1);
    }

    public MuleMessage route(MuleEvent event) throws MessagingException {
        String inboundEndpoint = event.getEndpoint().getEndpointURI().getEndpointName();
        if (StringUtils.isBlank((String)inboundEndpoint)) {
            inboundEndpoint = event.getEndpoint().getName();
        }
        if (StringUtils.isBlank((String)inboundEndpoint)) {
            inboundEndpoint = event.getEndpoint().getEndpointURI().getUri().toString();
        }
        event.getMessage().setProperty("MULE_ORIGINATING_ENDPOINT", inboundEndpoint);
        if (this.endpoints.size() > 0 && this.routers.size() == 0) {
            this.addRouter(new InboundPassThroughRouter());
        }
        String componentName = event.getSession().getService().getName();
        MuleEvent[] eventsToRoute = null;
        boolean noRoute = true;
        boolean match = false;
        for (InboundRouter umoInboundRouter : this.getRouters()) {
            if (!umoInboundRouter.isMatch(event)) continue;
            match = true;
            eventsToRoute = umoInboundRouter.process(event);
            boolean bl = noRoute = eventsToRoute == null;
            if (this.matchAll) continue;
        }
        if (!event.isStopFurtherProcessing()) {
            if (noRoute) {
                if (this.getStatistics().isEnabled()) {
                    this.getStatistics().incrementNoRoutedMessage();
                }
                if (!match) {
                    if (this.getCatchAllStrategy() != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Message did not match any routers on: " + componentName + " - invoking catch all strategy"));
                        }
                        if (this.getStatistics().isEnabled()) {
                            this.getStatistics().incrementCaughtMessage();
                        }
                        return this.getCatchAllStrategy().catchMessage(event.getMessage(), event.getSession(), event.isSynchronous());
                    }
                    this.logger.warn((Object)("Message did not match any routers on: " + componentName + " and there is no catch all strategy configured on this router.  Disposing message: " + event));
                    if (this.logger.isDebugEnabled()) {
                        try {
                            this.logger.warn((Object)("Message fragment is: " + StringMessageUtils.truncate(event.getMessageAsString(), 100, true)));
                        }
                        catch (MuleException e) {}
                    }
                }
            } else {
                try {
                    MuleMessage messageResult = null;
                    for (int i = 0; i < eventsToRoute.length; ++i) {
                        if (event.getMessage().getProperty("MULE_ORIGINATING_ENDPOINT") == null) {
                            event.getMessage().setProperty("MULE_ORIGINATING_ENDPOINT", inboundEndpoint);
                        }
                        if (event.isSynchronous()) {
                            messageResult = this.send(eventsToRoute[i]);
                        } else {
                            this.dispatch(eventsToRoute[i]);
                        }
                        if (!this.getStatistics().isEnabled()) continue;
                        this.getStatistics().incrementRoutedMessage(eventsToRoute[i].getEndpoint());
                    }
                    return messageResult;
                }
                catch (MuleException e) {
                    throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
                }
            }
        }
        return eventsToRoute != null && eventsToRoute.length > 0 ? eventsToRoute[eventsToRoute.length - 1].getMessage() : null;
    }

    public void dispatch(MuleEvent event) throws MuleException {
        event.getSession().dispatchEvent(event);
    }

    public MuleMessage send(MuleEvent event) throws MuleException {
        return event.getSession().sendEvent(event);
    }

    public void addRouter(InboundRouter router) {
        this.routers.add(router);
    }

    public InboundRouter removeRouter(InboundRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(InboundEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(InboundEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        if (endpoints != null) {
            this.endpoints.clear();
            for (ImmutableEndpoint endpoint : endpoints) {
                if (endpoint instanceof InboundEndpoint) continue;
                throw new InvalidEndpointTypeException(CoreMessages.inboundRouterMustUseInboundEndpoints(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("List of endpoints = null");
        }
        this.endpoints.addAll(endpoints);
    }

    public InboundEndpoint getEndpoint(String name) {
        for (InboundEndpoint endpointDescriptor : this.endpoints) {
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }
}

