/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceDescriptorFactory;
import org.mule.api.registry.ServiceException;
import org.mule.api.service.Service;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.GenericLifecycleManager;
import org.mule.lifecycle.phases.TransientRegistryDisposePhase;
import org.mule.lifecycle.phases.TransientRegistryInitialisePhase;
import org.mule.registry.AbstractRegistry;
import org.mule.registry.ExpressionEvaluatorProcessor;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;

public class TransientRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog(TransientRegistry.class);
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    private Map registry;

    public TransientRegistry() {
        super(REGISTRY_ID);
        this.init();
    }

    public TransientRegistry(Registry parent) {
        super(REGISTRY_ID, parent);
        this.init();
    }

    private void init() {
        this.registry = new HashMap(8);
        this.getObjectTypeMap(ObjectProcessor.class).put("_muleExpressionEvaluatorProcessor", new ExpressionEvaluatorProcessor());
        RegistryContext.setRegistry(this);
        try {
            this.initialise();
        }
        catch (InitialisationException e) {
            this.logger.error((Object)e);
        }
    }

    protected LifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        TransientRegistryInitialisePhase initPhase = new TransientRegistryInitialisePhase();
        initPhase.setRegistryScope(0);
        lcm.registerLifecycle(initPhase);
        TransientRegistryDisposePhase disposePhase = new TransientRegistryDisposePhase();
        disposePhase.setRegistryScope(0);
        lcm.registerLifecycle(disposePhase);
        return lcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialise() throws InitialisationException {
        int oldScope = this.getDefaultScope();
        this.setDefaultScope(0);
        try {
            this.applyProcessors(this.getConnectors());
            this.applyProcessors(this.getTransformers());
            this.applyProcessors(this.getEndpoints());
            this.applyProcessors(this.getAgents());
            this.applyProcessors(this.getModels());
            this.applyProcessors(this.lookupServices());
            this.applyProcessors(this.lookupObjects(Object.class));
        }
        finally {
            this.setDefaultScope(oldScope);
        }
    }

    protected void applyProcessors(Map objects) {
        if (objects == null) {
            return;
        }
        for (Object o : objects.values()) {
            Collection processors = this.lookupObjects(ObjectProcessor.class);
            for (ObjectProcessor op : processors) {
                op.process(o);
            }
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry entry : objects.entrySet()) {
            this.registerObject(entry.getKey().toString(), entry.getValue());
        }
    }

    protected Object doLookupObject(String key) {
        Object o = null;
        if (key != null) {
            for (Map map : this.registry.values()) {
                o = map.get(key);
                if (o == null) continue;
                return o;
            }
        }
        return o;
    }

    public Collection doLookupObjects(Class returntype) {
        Map map = (Map)this.registry.get(returntype);
        if (map != null) {
            return map.values();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        String key = new AbstractServiceDescriptor.Key(name, overrides).getKey();
        ServiceDescriptor sd = (ServiceDescriptor)this.lookupObject(key);
        TransientRegistry transientRegistry = this;
        synchronized (transientRegistry) {
            if (sd == null) {
                sd = this.createServiceDescriptor(type, name, overrides);
                try {
                    this.registerObject(key, sd, ServiceDescriptor.class);
                }
                catch (RegistrationException e) {
                    throw new ServiceException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        return sd;
    }

    protected ServiceDescriptor createServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this);
    }

    protected Map getObjectTypeMap(Object o) {
        Class key;
        HashMap objects;
        if (o == null) {
            o = Object.class;
        }
        if ((objects = (HashMap)this.registry.get(key = o instanceof Class ? o : (o instanceof String ? o : o.getClass()))) == null) {
            objects = new HashMap(8);
            this.registry.put(key, objects);
        }
        return objects;
    }

    protected Object applyProcessors(Object object) {
        Object theObject = object;
        Collection processors = this.lookupObjects(ObjectProcessor.class, null != this.getParent() && this.getParent().isInitialised() ? this.getDefaultScope() : 0);
        for (ObjectProcessor o : processors) {
            theObject = o.process(theObject);
        }
        return theObject;
    }

    protected void doRegisterObject(String key, Object value) throws RegistrationException {
        this.doRegisterObject(key, value, Object.class);
    }

    protected void doRegisterObject(String key, Object object, Object metadata) throws RegistrationException {
        Map objectMap;
        this.logger.debug((Object)"registering object");
        if (this.isInitialised() || this.isInitialising()) {
            this.logger.debug((Object)"applying processors");
            object = this.applyProcessors(object);
        }
        if ((objectMap = this.getObjectTypeMap(metadata)) != null) {
            if (objectMap.containsKey(key)) {
                this.logger.warn((Object)("TransientRegistry already contains an object named '" + key + "'.  The previous object will be overwritten."));
            }
            objectMap.put(key, object);
            try {
                MuleContext mc = MuleServer.getMuleContext();
                this.logger.debug((Object)("context: " + mc));
                if (mc == null) {
                    throw new RegistrationException("Unable to register object (\"" + key + ":" + ClassUtils.getSimpleName(object.getClass()) + "\") because MuleContext has not yet been created.");
                }
                this.logger.debug((Object)"applying lifecycle");
                mc.applyLifecycle(object);
            }
            catch (MuleException e) {
                throw new RegistrationException(e);
            }
        } else {
            throw new RegistrationException("No object map exists for type " + metadata);
        }
    }

    public void registerAgent(Agent agent) throws MuleException {
        this.registerObject(agent.getName(), agent, Agent.class);
    }

    public void registerConnector(Connector connector) throws MuleException {
        this.registerObject(connector.getName(), connector, Connector.class);
    }

    public void registerEndpoint(ImmutableEndpoint endpoint) throws MuleException {
        this.registerObject(endpoint.getName(), endpoint, ImmutableEndpoint.class);
    }

    public void registerEndpointBuilder(String name, EndpointBuilder builder) throws MuleException {
        this.registerObject(name, builder, EndpointBuilder.class);
    }

    public void registerModel(Model model) throws MuleException {
        this.registerObject(model.getName(), model, Model.class);
    }

    protected void doRegisterTransformer(Transformer transformer) throws MuleException {
        if (this.lookupTransformer(transformer.getName()) != null) {
            throw new RegistrationException(CoreMessages.objectAlreadyRegistered("transformer: " + transformer.getName(), this.lookupTransformer(transformer.getName()), transformer).getMessage());
        }
        this.registerObject(transformer.getName(), transformer, Transformer.class);
    }

    public void registerService(Service service) throws MuleException {
        this.registerObject(service.getName(), service, Service.class);
    }

    protected void unregisterObject(String key, Object metadata) throws MuleException {
        Object obj = this.getObjectTypeMap(metadata).remove(key);
        if (obj instanceof Stoppable) {
            ((Stoppable)obj).stop();
        }
    }

    public void unregisterObject(String key) throws MuleException {
        this.unregisterObject(key, Object.class);
    }

    public void unregisterService(String serviceName) throws MuleException {
        this.unregisterObject(serviceName, Service.class);
    }

    public void unregisterAgent(String agentName) throws MuleException {
        this.unregisterObject(agentName, Agent.class);
    }

    public void unregisterConnector(String connectorName) throws MuleException {
        this.unregisterObject(connectorName, Connector.class);
    }

    public void unregisterEndpoint(String endpointName) throws MuleException {
        this.unregisterObject(endpointName, ImmutableEndpoint.class);
    }

    public void unregisterModel(String modelName) throws MuleException {
        this.unregisterObject(modelName, Model.class);
    }

    public void unregisterTransformer(String transformerName) throws MuleException {
        Transformer transformer = this.lookupTransformer(transformerName);
        if (transformer instanceof DiscoverableTransformer) {
            this.exactTransformerCache.clear();
            this.transformerListCache.clear();
        }
        this.unregisterObject(transformerName, Transformer.class);
    }

    public Transformer lookupTransformer(String name) {
        Transformer transformer = super.lookupTransformer(name);
        if (transformer != null) {
            try {
                if (transformer.getEndpoint() != null) {
                    throw new IllegalStateException("Endpoint cannot be set");
                }
                transformer = (Transformer)BeanUtils.cloneBean((Object)transformer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return transformer;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }
}

