/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.security.provider;

import java.security.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.api.security.provider.IBMSecurityProviderInfo;
import org.mule.api.security.provider.SecurityProviderFactory;
import org.mule.api.security.provider.SecurityProviderInfo;
import org.mule.api.security.provider.SunSecurityProviderInfo;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.SystemUtils;

public class AutoDiscoverySecurityProviderFactory
implements SecurityProviderFactory {
    public static final SecurityProviderInfo DEFAULT_SECURITY_PROVIDER = new SunSecurityProviderInfo();
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static final SecurityProviderInfo IBM_SECURITY_PROVIDER = new IBMSecurityProviderInfo();

    public SecurityProviderInfo getSecurityProviderInfo() {
        SecurityProviderInfo info = SystemUtils.isIbmJDK() ? IBM_SECURITY_PROVIDER : DEFAULT_SECURITY_PROVIDER;
        return info;
    }

    public Provider getProvider() {
        SecurityProviderInfo info = this.getSecurityProviderInfo();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using " + info.getClass().getName()));
        }
        try {
            return (Provider)ClassUtils.instanciateClass(info.getProviderClass(), null);
        }
        catch (Exception ex) {
            throw new MuleRuntimeException(CoreMessages.failedToInitSecurityProvider(info.getProviderClass()), (Throwable)ex);
        }
    }
}

