/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.object;

import java.util.Map;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.object.AbstractObjectFactory;
import org.mule.util.object.Identifiable;

public class SingletonObjectFactory
extends AbstractObjectFactory {
    private Object instance = null;

    public SingletonObjectFactory() {
    }

    public SingletonObjectFactory(String objectClassName) {
        super(objectClassName);
    }

    public SingletonObjectFactory(String objectClassName, Map properties) {
        super(objectClassName, properties);
    }

    public SingletonObjectFactory(Class objectClass) {
        super(objectClass);
    }

    public SingletonObjectFactory(Class objectClass, Map properties) {
        super(objectClass, properties);
    }

    public SingletonObjectFactory(Object instance) {
        this.instance = instance;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.instance == null) {
            try {
                this.instance = super.getOrCreate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void dispose() {
        if (this.instance != null && this.instance instanceof Disposable) {
            ((Disposable)this.instance).dispose();
        }
        this.instance = null;
    }

    public Object getOrCreate() throws Exception {
        if (this.instance != null) {
            return this.instance;
        }
        throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
    }

    public Object lookup(String id) throws Exception {
        if (this.instance != null && this.instance instanceof Identifiable && id != null) {
            if (id.equals(((Identifiable)this.instance).getId())) {
                return this.instance;
            }
            return null;
        }
        return this.instance;
    }

    public void release(Object object) throws Exception {
    }

    public Class getObjectClass() {
        if (this.instance != null) {
            return this.instance.getClass();
        }
        return super.getObjectClass();
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }
}

