/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.object;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.PoolingProfile;
import org.mule.util.UUID;
import org.mule.util.object.AbstractObjectFactory;
import org.mule.util.object.Identifiable;

public class PooledObjectFactory
extends AbstractObjectFactory
implements KeyedPoolableObjectFactory {
    protected GenericKeyedObjectPool pool = null;
    protected PoolingProfile poolingProfile = null;

    public PooledObjectFactory() {
    }

    public PooledObjectFactory(Class objectClass) {
        super(objectClass);
    }

    public PooledObjectFactory(Class objectClass, Map properties) {
        super(objectClass, properties);
    }

    public PooledObjectFactory(Class objectClass, PoolingProfile poolingProfile) {
        super(objectClass);
        this.poolingProfile = poolingProfile;
    }

    public PooledObjectFactory(Class objectClass, Map properties, PoolingProfile poolingProfile) {
        super(objectClass, properties);
        this.poolingProfile = poolingProfile;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.poolingProfile != null) {
            config.maxIdle = this.poolingProfile.getMaxIdle();
            config.maxActive = this.poolingProfile.getMaxActive();
            config.maxWait = this.poolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.poolingProfile.getExhaustedAction();
        }
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)this, config);
        try {
            this.applyInitialisationPolicy();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInitialisationPolicy() throws Exception {
        if (this.poolingProfile != null) {
            int t;
            int numToBorrow = 0;
            int initPolicy = this.poolingProfile.getInitialisationPolicy();
            if (initPolicy == 2) {
                numToBorrow = this.poolingProfile.getMaxActive();
            } else if (initPolicy == 1) {
                numToBorrow = 1;
            }
            ArrayList<Object> holderList = new ArrayList<Object>(numToBorrow);
            try {
                for (t = 0; t < numToBorrow; ++t) {
                    holderList.add(this.getOrCreate());
                }
            }
            finally {
                for (t = 0; t < holderList.size(); ++t) {
                    Object obj = holderList.get(t);
                    if (obj == null) continue;
                    this.release(obj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Exception e) {
                this.logger.warn((Object)e);
            }
            finally {
                this.pool = null;
            }
        }
    }

    public Object getOrCreate() throws Exception {
        return this.pool.borrowObject((Object)UUID.getUUID());
    }

    public Object lookup(String id) throws Exception {
        return this.pool.borrowObject((Object)id);
    }

    public void release(Object object) throws Exception {
        if (object instanceof Identifiable) {
            this.pool.returnObject((Object)((Identifiable)object).getId(), object);
        }
    }

    public Object makeObject(Object key) throws Exception {
        Object obj = super.getOrCreate();
        if (obj instanceof Identifiable) {
            ((Identifiable)obj).setId((String)key);
        }
        return obj;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof Disposable) {
            ((Disposable)obj).dispose();
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }

    public boolean validateObject(Object key, Object obj) {
        return true;
    }

    public int getPoolSize() {
        if (this.pool != null) {
            return this.pool.getNumActive();
        }
        return 0;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }
}

