/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.monitor;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.lifecycle.Disposable;
import org.mule.util.monitor.Expirable;

public class ExpiryMonitor
extends TimerTask
implements Disposable {
    protected static final Log logger = LogFactory.getLog(ExpiryMonitor.class);
    private Timer timer = new Timer(true);
    private Map monitors;

    public ExpiryMonitor() {
        this(1000L);
    }

    public ExpiryMonitor(long monitorFrequency) {
        this.timer.schedule((TimerTask)this, monitorFrequency, monitorFrequency);
        this.monitors = new ConcurrentHashMap();
    }

    public void addExpirable(long milliseconds, Expirable expirable) {
        if (this.isRegistered(expirable)) {
            this.resetExpirable(expirable);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding new expirable: " + expirable));
            }
            this.monitors.put(expirable, new ExpirableHolder(milliseconds, expirable));
        }
    }

    public boolean isRegistered(Expirable expirable) {
        return this.monitors.get(expirable) != null;
    }

    public void removeExpirable(Expirable expirable) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing expirable: " + expirable));
        }
        this.monitors.remove(expirable);
    }

    public void resetExpirable(Expirable expirable) {
        ExpirableHolder eh = (ExpirableHolder)this.monitors.get(expirable);
        if (eh != null) {
            eh.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reset expirable: " + expirable));
            }
        }
    }

    public void run() {
        for (ExpirableHolder holder : this.monitors.values()) {
            if (!holder.isExpired()) continue;
            this.removeExpirable(holder.getExpirable());
            holder.getExpirable().expired();
        }
    }

    public void dispose() {
        logger.info((Object)"disposing monitor");
        this.timer.cancel();
        for (ExpirableHolder holder : this.monitors.values()) {
            this.removeExpirable(holder.getExpirable());
            try {
                holder.getExpirable().expired();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
            }
        }
    }

    private class ExpirableHolder {
        private long milliseconds;
        private Expirable expirable;
        private long created;

        public ExpirableHolder(long milliseconds, Expirable expirable) {
            this.milliseconds = milliseconds;
            this.expirable = expirable;
            this.created = System.currentTimeMillis();
        }

        public long getMilliseconds() {
            return this.milliseconds;
        }

        public Expirable getExpirable() {
            return this.expirable;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.milliseconds > this.created;
        }

        public void reset() {
            this.created = System.currentTimeMillis();
        }
    }
}

