/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.model.ModelFactory;
import org.mule.transport.service.TransportFactory;
import org.mule.util.IOUtils;

public class SpiUtils {
    private static final Log logger = LogFactory.getLog(SpiUtils.class);
    public static final String SERVICE_ROOT = "META-INF/services/";
    public static final String MODEL_SERVICE_PATH = "org/mule/models/";
    public static final String PROVIDER_SERVICE_PATH = "org/mule/providers/";
    public static final String EXCEPTION_SERVICE_PATH = "org/mule/config/";

    public static Properties findServiceDescriptor(String type, String name) {
        if (type.equals("transport")) {
            return SpiUtils.findServiceDescriptor(PROVIDER_SERVICE_PATH, name, TransportFactory.class);
        }
        if (type.equals("model")) {
            return SpiUtils.findServiceDescriptor(MODEL_SERVICE_PATH, name, ModelFactory.class);
        }
        if (type.equals("exception")) {
            return SpiUtils.findServiceDescriptor(EXCEPTION_SERVICE_PATH, name, ExceptionHelper.class);
        }
        logger.warn((Object)("Attempt to lookup unrecognized service type: " + type));
        return null;
    }

    public static Properties findServiceDescriptor(String path, String name, Class currentClass) {
        if (!name.endsWith(".properties")) {
            name = name + ".properties";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path.startsWith(SERVICE_ROOT) ? path + name : SERVICE_ROOT + path + name;
        try {
            InputStream is = IOUtils.getResourceAsStream(path, currentClass, false, false);
            if (is != null) {
                Properties props = new Properties();
                try {
                    props.load(is);
                    return props;
                }
                catch (IOException e) {
                    logger.warn((Object)("Descriptor found but unable to load properties for service " + name));
                    return null;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

