/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleSession;
import org.mule.NullSessionHandler;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.SecurityException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.api.transport.Connector;
import org.mule.api.transport.InternalMessageListener;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.MessageNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Service service = null;
    protected ImmutableEndpoint endpoint = null;
    private InternalMessageListener listener;
    protected AbstractConnector connector = null;
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean stopped = new WaitableBoolean(true);
    protected final AtomicBoolean connecting = new AtomicBoolean(false);
    protected String receiverKey = null;
    private EndpointURI endpointUri;
    private WorkManager workManager;
    protected ConnectionStrategy connectionStrategy;
    protected boolean responseEndpoint = false;

    public AbstractMessageReceiver(Connector connector, Service service, ImmutableEndpoint endpoint) throws CreateException {
        this.setConnector(connector);
        this.setService(service);
        this.setEndpoint(endpoint);
        if (service.getResponseRouter() != null && service.getResponseRouter().getEndpoints().contains(endpoint)) {
            this.responseEndpoint = true;
        }
    }

    public void initialise() throws InitialisationException {
        this.listener = new DefaultInternalMessageListener();
        this.endpointUri = this.endpoint.getEndpointURI();
        try {
            this.workManager = this.connector.getReceiverWorkManager("receiver");
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.connectionStrategy = this.endpoint.getConnectionStrategy();
        this.doInitialise();
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void handleException(Exception exception) {
        if (exception instanceof ConnectException) {
            this.logger.info((Object)"Exception caught is a ConnectException, disconnecting receiver and invoking ReconnectStrategy");
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.connector.getExceptionListener().exceptionThrown(e);
            }
        }
        this.connector.getExceptionListener().exceptionThrown(exception);
        if (exception instanceof ConnectException) {
            try {
                this.logger.warn((Object)("Reconnecting after exception: " + exception.getMessage()), (Throwable)exception);
                this.connectionStrategy.connect(this);
            }
            catch (MuleException e) {
                this.connector.getExceptionListener().exceptionThrown(e);
            }
        }
    }

    protected void setExceptionDetails(MuleMessage message, Throwable exception) {
        String propName = ExceptionHelper.getErrorCodePropertyName(this.connector.getProtocol());
        if (propName != null) {
            String code = ExceptionHelper.getErrorMapping(this.connector.getProtocol(), exception.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting error code for: " + this.connector.getProtocol() + ", " + propName + "=" + code));
            }
            message.setProperty(propName, code);
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        if (connector != null) {
            if (!(connector instanceof AbstractConnector)) {
                throw new IllegalArgumentException(CoreMessages.propertyIsNotSupportedType("connector", AbstractConnector.class, connector.getClass()).getMessage());
            }
        } else {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("connector").getMessage());
        }
        this.connector = (AbstractConnector)connector;
    }

    public Service getService() {
        return this.service;
    }

    public final MuleMessage routeMessage(MuleMessage message) throws MuleException {
        return this.routeMessage(message, this.endpoint.isSynchronous() || TransactionCoordination.getInstance().getTransaction() != null);
    }

    public final MuleMessage routeMessage(MuleMessage message, boolean synchronous) throws MuleException {
        Transaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous) throws MuleException {
        return this.routeMessage(message, trans, synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, this.endpoint.isSynchronous(), outputStream);
    }

    public final MuleMessage routeMessage(MuleMessage message, boolean synchronous, OutputStream outputStream) throws MuleException {
        Transaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, outputStream);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
        if (this.connector.isEnableMessageEvents()) {
            this.connector.fireNotification(new MessageNotification(message, this.endpoint, this.service.getName(), 801));
        }
        if (this.endpoint.isRemoteSync()) {
            message.setBooleanProperty("MULE_REMOTE_SYNC", true);
        }
        if (message.getBooleanProperty("MULE_REMOTE_SYNC", false)) {
            synchronous = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message Received from: " + this.endpoint.getEndpointURI()));
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(message.getPayload()), 200, false)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(message)) {
            message = this.handleUnacceptedFilter(message);
            RequestContext.setEvent(new DefaultMuleEvent(message, this.endpoint, new DefaultMuleSession(message, new NullSessionHandler()), synchronous));
            return message;
        }
        return this.listener.onMessage(message, trans, synchronous, outputStream);
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        String messageId = message.getUniqueId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        }
        return null;
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        this.endpoint = endpoint;
    }

    public void setService(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("Service cannot be null");
        }
        this.service = service;
    }

    public final void dispose() {
        this.stop();
        this.disposing.set(true);
        this.doDispose();
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    protected WorkManager getWorkManager() {
        return this.workManager;
    }

    protected void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void connect() throws Exception {
        if (this.connected.get()) {
            return;
        }
        if (this.connecting.compareAndSet(false, true)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting: " + this));
            }
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Connected: " + this));
            return;
        }
        try {
            this.connectionStrategy.connect(this.connector);
            this.doConnect();
            this.connected.set(true);
            this.connecting.set(false);
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 701));
        }
        catch (Exception e) {
            this.connected.set(false);
            this.connecting.set(false);
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    public void disconnect() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected.set(false);
        this.logger.info((Object)("Disconnected: " + this));
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    public final void start() throws MuleException {
        if (this.stopped.compareAndSet(true, false)) {
            if (!this.connected.get()) {
                this.connectionStrategy.connect(this);
            }
            this.doStart();
        }
    }

    public final void stop() {
        try {
            if (this.connected.get()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.doStop();
            }
            catch (MuleException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    public InternalMessageListener getListener() {
        return this.listener;
    }

    public void setListener(InternalMessageListener listener) {
        this.listener = listener;
    }

    protected String getConnectEventId() {
        return this.connector.getName() + ".receiver (" + this.endpoint.getEndpointURI() + ")";
    }

    public void setReceiverKey(String receiverKey) {
        this.receiverKey = receiverKey;
    }

    public String getReceiverKey() {
        return this.receiverKey;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", receiverKey=").append(this.receiverKey);
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract void doDispose();

    private class DefaultInternalMessageListener
    implements InternalMessageListener {
        private DefaultInternalMessageListener() {
        }

        public MuleMessage onMessage(MuleMessage message, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
            MessageAdapter resultMessage = null;
            ResponseOutputStream ros = null;
            if (outputStream != null) {
                ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
            }
            DefaultMuleSession session = new DefaultMuleSession(message, AbstractMessageReceiver.this.connector.getSessionHandler(), AbstractMessageReceiver.this.service);
            MuleEvent muleEvent = new DefaultMuleEvent(message, AbstractMessageReceiver.this.endpoint, (MuleSession)session, synchronous, ros);
            muleEvent = OptimizedRequestContext.unsafeSetEvent(muleEvent);
            message = muleEvent.getMessage();
            boolean authorised = false;
            if (AbstractMessageReceiver.this.endpoint.getSecurityFilter() != null) {
                try {
                    AbstractMessageReceiver.this.endpoint.getSecurityFilter().authenticate(muleEvent);
                    authorised = true;
                }
                catch (SecurityException e) {
                    AbstractMessageReceiver.this.logger.warn((Object)("Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                    AbstractMessageReceiver.this.connector.fireNotification(new SecurityNotification(e, 401));
                    AbstractMessageReceiver.this.handleException(e);
                    resultMessage = RequestContext.getEvent().getMessage();
                }
            } else {
                authorised = true;
            }
            if (authorised) {
                if (AbstractMessageReceiver.this.responseEndpoint) {
                    AbstractMessageReceiver.this.service.getResponseRouter().route(muleEvent);
                    return null;
                }
                resultMessage = AbstractMessageReceiver.this.service.getInboundRouter().route(muleEvent);
            }
            if (resultMessage != null) {
                if (resultMessage.getExceptionPayload() != null) {
                    AbstractMessageReceiver.this.setExceptionDetails((MuleMessage)resultMessage, resultMessage.getExceptionPayload().getException());
                }
                resultMessage.applyTransformers(AbstractMessageReceiver.this.endpoint.getResponseTransformers());
            }
            return resultMessage;
        }
    }
}

