/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.Base64;

public class Base64Decoder
extends AbstractTransformer {
    public Base64Decoder() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(byte[].class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            String data = src instanceof byte[] ? new String((byte[])src, encoding) : (String)src;
            byte[] result = Base64.decode(data);
            if (this.getReturnClass().equals(String.class)) {
                return new String(result, encoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed("base64", this.getReturnClass().getName()), this, (Throwable)ex);
        }
    }
}

