/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.fruit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitLover;

public class FruitBowl {
    private static final Log logger = LogFactory.getLog(FruitBowl.class);
    private final Map bowl = Collections.synchronizedMap(new HashMap());

    public FruitBowl() {
    }

    public FruitBowl(Fruit[] fruit) {
        for (int i = 0; i < fruit.length; ++i) {
            this.bowl.put(fruit[i].getClass(), fruit[i]);
        }
    }

    public FruitBowl(Apple apple, Banana banana) {
        this.bowl.put(Apple.class, apple);
        this.bowl.put(Banana.class, banana);
    }

    public boolean hasApple() {
        return this.bowl.get(Apple.class) != null;
    }

    public boolean hasBanana() {
        return this.bowl.get(Banana.class) != null;
    }

    public Fruit[] addAppleAndBanana(Apple apple, Banana banana) {
        this.bowl.put(Apple.class, apple);
        this.bowl.put(Banana.class, banana);
        return new Fruit[]{apple, banana};
    }

    public Fruit[] addBananaAndApple(Banana banana, Apple apple) {
        this.bowl.put(Apple.class, apple);
        this.bowl.put(Banana.class, banana);
        return new Fruit[]{banana, apple};
    }

    public Object consumeFruit(FruitLover fruitlover) {
        logger.debug((Object)("Got a fruit lover who says: " + fruitlover.speak()));
        Iterator iter = this.bowl.values().iterator();
        while (iter.hasNext()) {
            ((Fruit)iter.next()).bite();
        }
        return fruitlover;
    }

    public void setFruit(Fruit[] fruit) {
        for (int i = 0; i < fruit.length; ++i) {
            this.bowl.put(fruit[i].getClass(), fruit[i]);
        }
    }

    public void setFruit(List fruit) {
        this.setFruit(fruit.toArray(new Fruit[fruit.size()]));
    }

    public Apple getApple() {
        return (Apple)this.bowl.get(Apple.class);
    }

    public void setApple(Apple apple) {
        this.bowl.put(Apple.class, apple);
    }

    public Banana getBanana() {
        return (Banana)this.bowl.get(Banana.class);
    }

    public void setBanana(Banana banana) {
        this.bowl.put(Banana.class, banana);
    }
}

