/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.beans.ExceptionListener;
import org.mule.api.DefaultMuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConnectorTestCase
extends AbstractMuleTestCase {
    protected String connectorName;

    public AbstractConnectorTestCase() {
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        Connector connector = this.createConnector();
        this.connectorName = connector.getName();
        if (this.connectorName == null) {
            AbstractConnectorTestCase.fail((String)"You need to set the connector name on the connector before returning it");
        }
        connector.setMuleContext(muleContext);
        muleContext.getRegistry().registerConnector(connector);
    }

    protected void doTearDown() throws Exception {
        Connector connector = this.getConnector();
        if (connector.isDisposed()) {
            AbstractConnectorTestCase.fail((String)("Connector has been disposed prematurely - lifecycle problem? Instance: " + connector));
        }
        connector.dispose();
    }

    protected Connector getConnector() {
        return muleContext.getRegistry().lookupConnector(this.connectorName);
    }

    public void testConnectorExceptionHandling() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        Mock ehandlerMock = new Mock(ExceptionListener.class, "exceptionHandler");
        ehandlerMock.expect("exceptionThrown", (Object)C.isA(Exception.class));
        AbstractConnectorTestCase.assertNotNull((Object)connector.getExceptionListener());
        connector.setExceptionListener((ExceptionListener)ehandlerMock.proxy());
        connector.handleException(new DefaultMuleException(MessageFactory.createStaticMessage("Dummy")));
        if (connector instanceof AbstractConnector) {
            ehandlerMock.expect("exceptionThrown", (Object)C.isA(Exception.class));
            ((AbstractConnector)connector).exceptionThrown(new DefaultMuleException(MessageFactory.createStaticMessage("Dummy")));
        }
        ehandlerMock.verify();
        connector.setExceptionListener(null);
        try {
            connector.handleException(new DefaultMuleException(MessageFactory.createStaticMessage("Dummy")));
            AbstractConnectorTestCase.fail((String)"Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConnectorLifecycle() throws Exception {
        Connector localConnector = this.createConnector();
        localConnector.setMuleContext(muleContext);
        localConnector.setName(this.connectorName + "-temp");
        localConnector.initialise();
        localConnector.start();
        AbstractConnectorTestCase.assertNotNull((Object)localConnector);
        AbstractConnectorTestCase.assertTrue((boolean)localConnector.isStarted());
        AbstractConnectorTestCase.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.stop();
        AbstractConnectorTestCase.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.dispose();
        AbstractConnectorTestCase.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((boolean)localConnector.isDisposed());
        try {
            localConnector.start();
            AbstractConnectorTestCase.fail((String)"Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectorListenerSupport() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        Service service = AbstractConnectorTestCase.getTestService("anApple", Apple.class);
        ImmutableEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(this.getTestEndpointURI());
        try {
            connector.registerListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(service, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.registerListener(service, endpoint);
        connector.unregisterListener(service, endpoint);
        try {
            connector.unregisterListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(service, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.unregisterListener(service, endpoint);
        muleContext.getRegistry().unregisterComponent(service.getName());
    }

    public void testConnectorBeanProps() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        try {
            connector.setName(null);
            AbstractConnectorTestCase.fail((String)"Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        connector.setName("Test");
        AbstractConnectorTestCase.assertEquals((String)"Test", (String)connector.getName());
        AbstractConnectorTestCase.assertNotNull((String)"Protocol must be set as a constant", (Object)connector.getProtocol());
    }

    public void testConnectorMessageAdapter() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        MessageAdapter adapter = connector.getMessageAdapter(this.getValidMessage());
        AbstractConnectorTestCase.assertNotNull((Object)adapter);
    }

    public void testConnectorMessageDispatcherFactory() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        MessageDispatcherFactory factory = connector.getDispatcherFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorMessageRequesterFactory() throws Exception {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        MessageRequesterFactory factory = connector.getRequesterFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorInitialise() throws Exception {
        Connector connector = this.getConnector();
        try {
            connector.initialise();
            AbstractConnectorTestCase.fail((String)"A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract Connector createConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();
}

