/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import com.mockobjects.dynamic.Mock;
import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleContext;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.mule.TestAgent;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.object.SingletonObjectFactory;

public final class MuleTestUtils {
    public static Endpoint getTestInboundEndpoint(String name, final MuleContext context) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, context, new EndpointSource(){

            public Endpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return (Endpoint)context.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
            }
        });
    }

    public static Endpoint getTestOutboundEndpoint(String name, final MuleContext context) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, context, new EndpointSource(){

            public Endpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return (Endpoint)context.getRegistry().lookupEndpointFactory().getOutboundEndpoint(builder);
            }
        });
    }

    private static Endpoint getTestEndpoint(String name, MuleContext context, EndpointSource source) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", name);
        props.put("endpointURI", new MuleEndpointURI("test://test"));
        props.put("connector", "testConnector");
        AbstractConnector connector = (AbstractConnector)ClassUtils.loadClass("org.mule.tck.testmodels.mule.TestConnector", AbstractMuleTestCase.class).newInstance();
        connector.setName("testConnector");
        connector.setMuleContext(context);
        context.applyLifecycle(connector);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://test", context);
        endpointBuilder.setConnector(connector);
        endpointBuilder.setName(name);
        return source.getEndpoint(endpointBuilder);
    }

    public static Endpoint getTestSchemeMetaInfoInboundEndpoint(String name, String protocol, final MuleContext context) throws Exception {
        return MuleTestUtils.getTestSchemeMetaInfoEndpoint(name, protocol, context, new EndpointSource(){

            public Endpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return (Endpoint)context.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
            }
        });
    }

    public static Endpoint getTestSchemeMetaInfoOutboundEndpoint(String name, String protocol, final MuleContext context) throws Exception {
        return MuleTestUtils.getTestSchemeMetaInfoEndpoint(name, protocol, context, new EndpointSource(){

            public Endpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return (Endpoint)context.getRegistry().lookupEndpointFactory().getOutboundEndpoint(builder);
            }
        });
    }

    private static Endpoint getTestSchemeMetaInfoEndpoint(String name, String protocol, MuleContext context, EndpointSource source) throws Exception {
        AbstractConnector connector = (AbstractConnector)ClassUtils.loadClass("org.mule.tck.testmodels.mule.TestConnector", AbstractMuleTestCase.class).newInstance();
        connector.setName("testConnector");
        connector.setMuleContext(context);
        context.applyLifecycle(connector);
        connector.registerSupportedProtocol(protocol);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test:" + protocol + "://test", context);
        endpointBuilder.setConnector(connector);
        endpointBuilder.setName(name);
        return source.getEndpoint(endpointBuilder);
    }

    public static MuleEvent getTestEvent(Object data, MuleContext context) throws Exception {
        return MuleTestUtils.getTestEvent(data, MuleTestUtils.getTestService(context), context);
    }

    public static MuleEvent getTestEvent(Object data, Service service, MuleContext context) throws Exception {
        return MuleTestUtils.getTestEvent(data, service, MuleTestUtils.getTestOutboundEndpoint("test1", context), context);
    }

    public static MuleEvent getTestEvent(Object data, ImmutableEndpoint endpoint, MuleContext context) throws Exception {
        return MuleTestUtils.getTestEvent(data, MuleTestUtils.getTestService(context), endpoint, context);
    }

    public static MuleEvent getTestEvent(Object data, Service service, ImmutableEndpoint endpoint, MuleContext context) throws Exception {
        MuleSession session = MuleTestUtils.getTestSession(service);
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(data, new HashMap()), endpoint, session, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MuleEventContext getTestEventContext(Object data, MuleContext context) throws Exception {
        try {
            MuleEvent event = MuleTestUtils.getTestEvent(data, context);
            RequestContext.setEvent(event);
            MuleEventContext muleEventContext = RequestContext.getEventContext();
            return muleEventContext;
        }
        finally {
            RequestContext.setEvent(null);
        }
    }

    public static Transformer getTestTransformer() throws Exception {
        TestCompressionTransformer t = new TestCompressionTransformer();
        t.initialise();
        return t;
    }

    public static MuleSession getTestSession(Service service) {
        return new DefaultMuleSession(service);
    }

    public static MuleSession getTestSession() {
        return MuleTestUtils.getTestSession(null);
    }

    public static TestConnector getTestConnector(MuleContext context) throws Exception {
        TestConnector testConnector = new TestConnector();
        testConnector.setName("testConnector");
        testConnector.setMuleContext(context);
        context.applyLifecycle(testConnector);
        return testConnector;
    }

    public static Service getTestService(MuleContext context) throws Exception {
        return MuleTestUtils.getTestService("appleService", Apple.class, context);
    }

    public static Service getTestService(String name, Class clazz, MuleContext context) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, null, context);
    }

    public static Service getTestService(String name, Class clazz, Map props, MuleContext context) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, props, context, true);
    }

    public static Service getTestService(String name, Class clazz, Map props, MuleContext context, boolean initialize) throws Exception {
        SedaModel model = new SedaModel();
        model.setMuleContext(context);
        context.applyLifecycle(model);
        SedaService c = new SedaService();
        c.setName(name);
        SingletonObjectFactory of = new SingletonObjectFactory(clazz, props);
        of.initialise();
        c.setServiceFactory(of);
        c.setModel(model);
        if (initialize) {
            context.getRegistry().registerService(c);
            OutboundPassThroughRouter router = new OutboundPassThroughRouter();
            c.getOutboundRouter().addRouter(router);
        }
        return c;
    }

    public static TestAgent getTestAgent() throws Exception {
        TestAgent t = new TestAgent();
        t.initialise();
        return t;
    }

    public static Mock getMockSession() {
        return new Mock(MuleSession.class, "umoSession");
    }

    public static Mock getMockMessageDispatcher() {
        return new Mock(MessageDispatcher.class, "umoMessageDispatcher");
    }

    public static Mock getMockMessageDispatcherFactory() {
        return new Mock(MessageDispatcherFactory.class, "umoMessageDispatcherFactory");
    }

    public static Mock getMockConnector() {
        return new Mock(Connector.class, "umoConnector");
    }

    public static Mock getMockEvent() {
        return new Mock(MuleEvent.class, "umoEvent");
    }

    public static Mock getMockMuleContext() {
        return new Mock(DefaultMuleContext.class, "muleMuleContext");
    }

    public static Mock getMockEndpoint() {
        return new Mock(Endpoint.class, "umoEndpoint");
    }

    public static Mock getMockEndpointURI() {
        return new Mock(EndpointURI.class, "umoEndpointUri");
    }

    public static Mock getMockTransaction() {
        return new Mock(Transaction.class, "umoTransaction");
    }

    public static Mock getMockTransactionFactory() {
        return new Mock(TransactionFactory.class, "umoTransactionFactory");
    }

    private static interface EndpointSource {
        public Endpoint getEndpoint(EndpointBuilder var1) throws MuleException;
    }
}

