/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.Model;
import org.mule.api.model.ModelException;
import org.mule.api.model.MuleProxy;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.api.service.ServiceException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageReceiver;
import org.mule.component.DefaultMuleProxy;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ServiceNotification;
import org.mule.management.stats.ServiceStatistics;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.routing.nested.DefaultNestedRouterCollection;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.routing.response.DefaultResponseRouterCollection;
import org.mule.service.DefaultServiceExceptionStrategy;
import org.mule.transport.AbstractConnector;
import org.mule.util.concurrent.WaitableBoolean;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public abstract class AbstractService
implements Service {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ServiceStatistics stats = null;
    protected AtomicBoolean stopped = new AtomicBoolean(true);
    protected WaitableBoolean stopping = new WaitableBoolean(false);
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected Model model;
    protected WaitableBoolean paused = new WaitableBoolean(false);
    protected MuleContext muleContext;
    protected EntryPointResolverSet entryPointResolverSet;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected ExceptionListener exceptionListener;
    protected ObjectFactory serviceFactory = new SingletonObjectFactory(PassThroughComponent.class);
    protected String name;
    protected InboundRouterCollection inboundRouter = new DefaultInboundRouterCollection();
    protected OutboundRouterCollection outboundRouter = new DefaultOutboundRouterCollection();
    protected NestedRouterCollection nestedRouter = new DefaultNestedRouterCollection();
    protected ResponseRouterCollection responseRouter = new DefaultResponseRouterCollection();
    protected String initialState = "started";
    protected List initialisationCallbacks = new ArrayList();
    private AtomicBoolean beyondInitialState = new AtomicBoolean(false);
    protected Map properties = new HashMap();

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(CoreMessages.objectAlreadyInitialised("Service '" + this.name + "'"), (Initialisable)this);
        }
        if (this.inboundRouter == null) {
            this.inboundRouter = new DefaultInboundRouterCollection();
            this.inboundRouter.addRouter(new InboundPassThroughRouter());
        }
        if (this.outboundRouter == null) {
            this.outboundRouter = new DefaultOutboundRouterCollection();
            this.outboundRouter.addRouter(new OutboundPassThroughRouter());
        }
        if (this.responseRouter == null) {
            this.responseRouter = new DefaultResponseRouterCollection();
        }
        if (this.nestedRouter == null) {
            this.nestedRouter = new DefaultNestedRouterCollection();
        }
        if (this.exceptionListener == null) {
            this.exceptionListener = new DefaultServiceExceptionStrategy(this);
            ((MuleContextAware)((Object)this.exceptionListener)).setMuleContext(this.muleContext);
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        this.serviceFactory.initialise();
        this.doInitialise();
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.outboundRouter.getStatistics());
        this.stats.setInboundRouterStat(this.inboundRouter.getStatistics());
        this.initialised.set(true);
        this.fireComponentNotification(301);
    }

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.name);
    }

    protected void fireComponentNotification(int action) {
        this.muleContext.fireNotification(new ServiceNotification(this, action));
    }

    public void forceStop() throws MuleException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping Service");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.doForceStop();
            this.stopped.set(true);
            this.stopping.set(false);
            this.fireComponentNotification(303);
        }
    }

    public void stop() throws MuleException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping Service");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.unregisterListeners();
            this.doStop();
            this.stopped.set(true);
            this.initialised.set(false);
            this.fireComponentNotification(303);
            this.logger.info((Object)("Mule Service " + this.name + " has been stopped successfully"));
        }
    }

    public void start() throws MuleException {
        if (this.isStarted()) {
            this.logger.info((Object)("Service is already started: " + this.name));
            return;
        }
        if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.logger.info((Object)("Service " + this.name + " has not been started (initial state = 'stopped')"));
        } else if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_PAUSED)) {
            this.start(true);
            this.logger.info((Object)("Service " + this.name + " has been started and paused (initial state = 'paused')"));
        } else {
            this.start(false);
            this.logger.info((Object)("Service " + this.name + " has been started successfully"));
        }
        this.beyondInitialState.set(true);
    }

    protected void start(boolean startPaused) throws MuleException {
        this.registerListeners();
        this.connectListeners();
        if (this.stopped.get()) {
            this.stopped.set(false);
            this.paused.set(false);
            this.doStart();
        }
        this.fireComponentNotification(302);
        if (startPaused) {
            this.pause();
        }
        this.startListeners();
    }

    public final void pause() throws MuleException {
        this.doPause();
        this.paused.set(true);
        this.fireComponentNotification(304);
        this.logger.info((Object)("Mule Service " + this.name + " has been paused successfully"));
    }

    public final void resume() throws MuleException {
        this.doResume();
        this.paused.set(false);
        this.fireComponentNotification(305);
        this.logger.info((Object)("Mule Service " + this.name + " has been resumed successfully"));
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    protected void doPause() throws MuleException {
    }

    protected void doResume() throws MuleException {
    }

    public final void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
        this.doDispose();
        this.fireComponentNotification(306);
        this.muleContext.getStatistics().remove(this.stats);
    }

    public ServiceStatistics getStatistics() {
        return this.stats;
    }

    public void dispatchEvent(MuleEvent event) throws MuleException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ServiceException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ServiceException(event.getMessage(), this, (Throwable)e);
        }
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (!endpoint.isInbound()) {
            try {
                endpoint.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.name + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        this.doDispatch(event);
    }

    public MuleMessage sendEvent(MuleEvent event) throws MuleException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ServiceException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ServiceException(event.getMessage(), this, (Throwable)e);
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.name + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        event = OptimizedRequestContext.unsafeSetEvent(event);
        return this.doSend(event);
    }

    protected void waitIfPaused(MuleEvent event) throws InterruptedException {
        if (this.logger.isDebugEnabled() && this.paused.get()) {
            this.logger.debug((Object)("Service: " + this.name + " is paused. Blocking call until resume is called"));
        }
        this.paused.whenFalse(null);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected void handleException(Exception e) {
        if (this.exceptionListener instanceof DefaultServiceExceptionStrategy && ((DefaultServiceExceptionStrategy)this.exceptionListener).getService() == null) {
            ((DefaultServiceExceptionStrategy)this.exceptionListener).setService(this);
        }
        this.exceptionListener.exceptionThrown(e);
    }

    protected void doForceStop() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doStart() throws MuleException {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    public boolean isStarted() {
        return !this.stopped.get();
    }

    protected abstract MuleMessage doSend(MuleEvent var1) throws MuleException;

    protected abstract void doDispatch(MuleEvent var1) throws MuleException;

    protected void registerListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            try {
                endpoint.getConnector().registerListener(this, endpoint);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedtoRegisterOnEndpoint(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            try {
                endpoint.getConnector().unregisterListener(this, endpoint);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToUnregister(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void startListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null || !endpoint.getConnector().isStarted() || !endpoint.getInitialState().equals(INITIAL_STATE_STARTED)) continue;
            receiver.start();
        }
    }

    protected void stopListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            receiver.stop();
        }
    }

    protected void connectListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.connect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to connect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected void disconnectListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (Endpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.disconnect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to disconnect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected List getIncomingEndpoints() {
        ArrayList endpoints = new ArrayList();
        endpoints.addAll(this.inboundRouter.getEndpoints());
        if (this.responseRouter != null && this.responseRouter.getEndpoints() != null) {
            endpoints.addAll(this.responseRouter.getEndpoints());
        }
        return endpoints;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected MuleProxy createComponentProxy(Object pojoService) throws MuleException {
        DefaultMuleProxy proxy = new DefaultMuleProxy(pojoService, this, this.muleContext);
        proxy.setStatistics(this.getStatistics());
        return proxy;
    }

    protected Object getOrCreateService() throws MuleException {
        Object component;
        if (this.serviceFactory == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Service " + this.name + " has not been initialized properly, no serviceFactory."), (Initialisable)this);
        }
        try {
            component = this.serviceFactory.getOrCreate();
            if (component instanceof ServiceAware) {
                ((ServiceAware)component).setService(this);
            }
        }
        catch (Exception e) {
            throw new LifecycleException(MessageFactory.createStaticMessage("Unable to create instance of POJO service"), e, this);
        }
        this.fireInitialisationCallbacks(component);
        return component;
    }

    public void fireInitialisationCallbacks(Object component) throws InitialisationException {
        for (InitialisationCallback callback : this.initialisationCallbacks) {
            callback.initialise(component);
        }
    }

    public void addInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public ObjectFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ObjectFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public InboundRouterCollection getInboundRouter() {
        return this.inboundRouter;
    }

    public void setInboundRouter(InboundRouterCollection inboundRouter) {
        this.inboundRouter = inboundRouter;
    }

    public NestedRouterCollection getNestedRouter() {
        return this.nestedRouter;
    }

    public void setNestedRouter(NestedRouterCollection nestedRouter) {
        this.nestedRouter = nestedRouter;
    }

    public OutboundRouterCollection getOutboundRouter() {
        return this.outboundRouter;
    }

    public void setOutboundRouter(OutboundRouterCollection outboundRouter) {
        this.outboundRouter = outboundRouter;
    }

    public ResponseRouterCollection getResponseRouter() {
        return this.responseRouter;
    }

    public void setResponseRouter(ResponseRouterCollection responseRouter) {
        this.responseRouter = responseRouter;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public void setEntryPointResolverSet(EntryPointResolverSet resolverSet) {
        this.entryPointResolverSet = resolverSet;
    }

    public void setEntryPointResolvers(Collection entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        Iterator resolvers = entryPointResolvers.iterator();
        while (resolvers.hasNext()) {
            this.entryPointResolverSet.addEntryPointResolver((EntryPointResolver)resolvers.next());
        }
    }
}

