/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class TransformerRouter
extends AbstractOutboundRouter {
    private Transformer transformer;

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws MessagingException {
        if (this.transformer != null) {
            try {
                Object payload = this.transformer.transform(message.getPayload());
                message = new DefaultMuleMessage(payload, message);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (ImmutableEndpoint)this.endpoints.get(0), e);
            }
        }
        return message;
    }

    public boolean isMatch(MuleMessage message) throws MessagingException {
        return true;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

