/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DynamicEndpointURIEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.util.TemplateParser;

public class TemplateEndpointRouter
extends FilteringOutboundRouter {
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        MuleMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        try {
            MuleEndpointURI newUri;
            ImmutableEndpoint ep = (ImmutableEndpoint)this.endpoints.get(0);
            String uri = ep.getEndpointURI().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Uri before parsing is: " + uri));
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.putAll(ep.getProperties());
            for (String propertyKey : message.getPropertyNames()) {
                props.put(propertyKey, message.getProperty(propertyKey));
            }
            uri = this.parser.parse(props, uri);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Uri after parsing is: " + uri));
            }
            if (!(newUri = new MuleEndpointURI(uri)).getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            ep = new DynamicEndpointURIEndpoint(ep, new MuleEndpointURI(uri));
            if (synchronous) {
                result = this.send(session, message, ep);
            } else {
                this.dispatch(session, message, ep);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, (ImmutableEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return result;
    }
}

