/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.routing.outbound.AbstractMessageSplitter;

public class FilteringListMessageSplitter
extends AbstractMessageSplitter {
    private final ThreadLocal payloadContext = new ThreadLocal();
    private final ThreadLocal propertiesContext = new ThreadLocal();

    protected void initialise(MuleMessage message) {
        if (message.getPayload() instanceof List) {
            LinkedList payload = new LinkedList((List)message.getPayload());
            this.payloadContext.set(payload);
            if (this.enableCorrelation != 2) {
                int groupSize = payload.size();
                message.setCorrelationGroupSize(groupSize);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("java.util.List payload detected, setting correlation group size to " + groupSize));
                }
            }
        } else {
            throw new IllegalArgumentException("The payload for this router must be of type java.util.List");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyKey : message.getPropertyNames()) {
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        this.propertiesContext.set(props);
    }

    protected void cleanup() {
        this.payloadContext.set(null);
        this.propertiesContext.set(null);
    }

    protected MuleMessage getMessagePart(MuleMessage message, ImmutableEndpoint endpoint) {
        List payloads = (List)this.payloadContext.get();
        Iterator i = payloads.iterator();
        while (i.hasNext()) {
            Object payload = i.next();
            DefaultMuleMessage result = new DefaultMuleMessage(payload, (Map)this.propertiesContext.get());
            if (endpoint.getFilter() != null && !endpoint.getFilter().accept(result)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
            }
            i.remove();
            return result;
        }
        return null;
    }
}

