/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.util.StringUtils;
import org.mule.util.properties.PropertyExtractorManager;

public class EndpointSelector
extends FilteringOutboundRouter
implements MuleContextAware {
    public static final String DEFAULT_SELECTOR_PROPERTY = "endpoint";
    private String selectorProperty = "endpoint";

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        List endpoints;
        Object property = PropertyExtractorManager.processExpression(this.getSelectorProperty(), message);
        if (property == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSetOnEvent(this.getSelectorProperty()), message, null);
        }
        if (property instanceof String) {
            endpoints = new ArrayList<Object>(1);
            endpoints.add(property);
        } else if (property instanceof List) {
            endpoints = (List)property;
        } else {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.getSelectorProperty(), new Class[]{String.class, List.class}, property.getClass()), message, null);
        }
        MuleMessage result = null;
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            String endpointName = iterator.next().toString();
            if (StringUtils.isEmpty((String)endpointName)) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.objectIsNull("Endpoint Name: " + this.getSelectorProperty()), message, null);
            }
            ImmutableEndpoint ep = null;
            try {
                ep = this.lookupEndpoint(endpointName);
                if (ep == null) {
                    throw new CouldNotRouteOutboundMessageException(CoreMessages.objectNotFound("Endpoint", endpointName), message, ep);
                }
                if (synchronous) {
                    result = this.send(session, message, ep);
                    continue;
                }
                this.dispatch(session, message, ep);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
            }
        }
        return result;
    }

    protected ImmutableEndpoint lookupEndpoint(String endpointName) throws MuleException {
        for (ImmutableEndpoint ep : this.endpoints) {
            if (endpointName.equals(ep.getEndpointURI().getEndpointName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        return this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName);
    }

    public String getSelectorProperty() {
        return this.selectorProperty;
    }

    public void setSelectorProperty(String selectorProperty) {
        this.selectorProperty = selectorProperty;
    }
}

